/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.AnnotationTarget;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.impl.AnnotationImpl;
import org.jboss.forge.parser.java.util.Types;

public class AnnotationAccessor<O extends JavaSource<O>, T> {
    public Annotation<O> addAnnotation(AnnotationTarget<O, T> target, BodyDeclaration body) {
        AnnotationImpl<O, T> annotation = new AnnotationImpl<O, T>(target);
        body.modifiers().add(0, annotation.getInternal());
        return annotation;
    }

    public Annotation<O> addAnnotation(AnnotationTarget<O, T> target, BodyDeclaration body, Class<?> clazz) {
        return this.addAnnotation(target, body, clazz.getName());
    }

    public Annotation<O> addAnnotation(AnnotationTarget<O, T> target, BodyDeclaration body, String className) {
        if (!((JavaSource)target.getOrigin()).hasImport(className) && Types.isQualified((String)className)) {
            ((JavaSource)target.getOrigin()).addImport(className);
        }
        return this.addAnnotation(target, body).setName(Types.toSimpleName((String)className));
    }

    public List<Annotation<O>> getAnnotations(AnnotationTarget<O, T> target, BodyDeclaration body) {
        ArrayList<AnnotationImpl<O, T>> result = new ArrayList<AnnotationImpl<O, T>>();
        List modifiers = body.modifiers();
        for (Object object : modifiers) {
            if (!(object instanceof org.eclipse.jdt.core.dom.Annotation)) continue;
            AnnotationImpl<O, T> annotation = new AnnotationImpl<O, T>(target, object);
            result.add(annotation);
        }
        return Collections.unmodifiableList(result);
    }

    public <E extends AnnotationTarget<O, T>> E removeAnnotation(E target, BodyDeclaration body, Annotation<O> annotation) {
        List modifiers = body.modifiers();
        for (Object object : modifiers) {
            if (!object.equals(annotation.getInternal())) continue;
            modifiers.remove(object);
            break;
        }
        return target;
    }

    public <E extends AnnotationTarget<O, T>> boolean hasAnnotation(E target, BodyDeclaration body, String type) {
        List modifiers = body.modifiers();
        for (Object object : modifiers) {
            AnnotationImpl annotation;
            String annotationType;
            if (!(object instanceof org.eclipse.jdt.core.dom.Annotation) || !Types.areEquivalent((String)type, (String)(annotationType = (annotation = new AnnotationImpl(target, object)).getName()))) continue;
            return true;
        }
        return false;
    }

    public Annotation<O> getAnnotation(AnnotationTarget<O, T> target, BodyDeclaration body, Class<? extends java.lang.annotation.Annotation> type) {
        Annotation<O> result = null;
        if (type != null) {
            result = this.getAnnotation(target, body, type.getName());
        }
        return result;
    }

    public Annotation<O> getAnnotation(AnnotationTarget<O, T> target, BodyDeclaration body, String type) {
        List<Annotation<O>> annotations = this.getAnnotations(target, body);
        for (Annotation<O> annotation : annotations) {
            if (!Types.areEquivalent((String)type, (String)annotation.getName())) continue;
            return annotation;
        }
        return null;
    }
}

