/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command.transaction;

import javax.inject.Inject;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.transaction.ResourceTransaction;
import org.jboss.forge.addon.shell.command.transaction.TrackChangesSettings;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class TransactionStartCommand
extends AbstractShellCommand {
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private TrackChangesSettings trackChangesSettings;
    @Inject
    @WithAttributes(label="Timeout", shortName=116, defaultValue="0")
    private UIInput<Integer> timeout;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("transaction-start").description("Starts a transaction");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.timeout);
    }

    public Result execute(UIExecutionContext shellContext) throws Exception {
        ResourceTransaction transaction = this.resourceFactory.getTransaction();
        if (transaction.isStarted()) {
            if (this.trackChangesSettings.isTrackChanges() && !this.trackChangesSettings.isInForeignTransaction()) {
                transaction.rollback();
            } else {
                return Results.fail((String)"Resource Transaction is already started");
            }
        }
        if (this.timeout.getValue() != null) {
            transaction.setTransactionTimeout(((Integer)this.timeout.getValue()).intValue());
        }
        transaction.begin();
        return Results.success((String)"Resource Transaction started");
    }

    public boolean isEnabled(ShellContext context) {
        return super.isEnabled(context) & !this.resourceFactory.getTransaction().isStarted();
    }
}

