/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.util.ResourcePathResolver;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class TouchCommand
extends AbstractShellCommand {
    @Inject
    ResourceFactory resourceFactory;
    @Inject
    @WithAttributes(label="Arguments", type="org.jboss.forge.inputType.FILE_PICKER", required=true)
    private UIInputMany<String> arguments;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("touch").description("Create a new file or modify file timestamp.");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.arguments);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Resource currentResource = (Resource)context.getUIContext().getInitialSelection().get();
        for (String path : this.arguments.getValue()) {
            List resources = new ResourcePathResolver(this.resourceFactory, currentResource, path).resolve();
            if (resources.isEmpty()) {
                return Results.fail((String)(path + ": path could not be resolved"));
            }
            for (Resource resource : resources) {
                FileResource file = (FileResource)resource.reify(FileResource.class);
                if (file == null) continue;
                if (file.exists()) {
                    file.setLastModified(System.currentTimeMillis());
                    continue;
                }
                if (file.createNewFile()) continue;
                return Results.fail((String)(path + ": file could not be created."));
            }
        }
        return Results.success();
    }
}

