/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jboss.forge.addon.ui.annotation.Command;
import org.jboss.forge.addon.ui.annotation.Option;
import org.jboss.forge.addon.ui.annotation.predicate.NonGUIEnabledPredicate;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.furnace.util.Strings;

public class DateCommand {
    @Command(value="date", help="print current date", enabled={NonGUIEnabledPredicate.class})
    public Result execute(@Option(value="pattern", description="The date pattern") String pattern, UIOutput output) {
        SimpleDateFormat dateFormat;
        if (!Strings.isNullOrEmpty((String)pattern)) {
            try {
                dateFormat = new SimpleDateFormat(pattern);
            }
            catch (IllegalArgumentException iae) {
                return Results.fail((String)("Illegal date pattern: " + pattern), (Throwable)iae);
            }
        } else {
            dateFormat = new SimpleDateFormat();
        }
        String date = dateFormat.format(new Date());
        output.out().println(date);
        return Results.success();
    }
}

