/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsBuilder;
import org.jboss.forge.addon.shell.Shell;
import org.jboss.forge.addon.shell.ShellFactory;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.container.cdi.events.Local;
import org.jboss.forge.furnace.event.PostStartup;
import org.jboss.forge.furnace.event.PreShutdown;
import org.jboss.forge.furnace.util.OperatingSystemUtils;

@Singleton
public class ShellInitializer {
    private Shell shell;
    @Inject
    private ShellFactory shellFactory;
    @Inject
    private Furnace furnace;

    public void startupDefaultShell(@Observes @Local PostStartup startup) throws Exception {
        if (Boolean.getBoolean("forge.shell.evaluate")) {
            String command = "";
            String[] args = this.furnace.getArgs();
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (!"-e".equals(arg) && !"--evaluate".equals(arg)) continue;
                command = args[++i];
                break;
            }
            if (!command.endsWith(OperatingSystemUtils.getLineSeparator())) {
                command = command + OperatingSystemUtils.getLineSeparator();
            }
            command = command + "exit" + OperatingSystemUtils.getLineSeparator() + "\u0000";
            Settings settings = new SettingsBuilder().inputStream((InputStream)new ByteArrayInputStream(command.getBytes())).outputStream(System.out).outputStreamError(System.err).ansi(false).create();
            this.shell = this.shellFactory.createShell(OperatingSystemUtils.getWorkingDir(), settings);
        } else if (Boolean.getBoolean("forge.standalone")) {
            new Thread(){

                @Override
                public void run() {
                    Settings settings = new SettingsBuilder().create();
                    ShellInitializer.this.shell = ShellInitializer.this.shellFactory.createShell(OperatingSystemUtils.getWorkingDir(), settings);
                }
            }.start();
        }
    }

    public void shutdown(@Observes @Local PreShutdown preShutdown) {
        this.destroyShell();
    }

    @PreDestroy
    public void destroyShell() {
        if (this.shell != null) {
            try {
                this.shell.close();
            }
            catch (Exception ignore) {
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Error while closing Shell", ignore);
            }
            this.shell = null;
        }
    }
}

