/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.monitor.model.hibernate;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerator {
    private AnnotationConfiguration cfg = new AnnotationConfiguration();
    private File output;

    public SchemaGenerator(String packageName, String output) throws Exception {
        this.cfg.setProperty("hibernate.hbm2ddl.auto", "create");
        for (Class<?> clazz : this.getClasses(packageName)) {
            this.cfg.addAnnotatedClass(clazz);
        }
        try {
            this.output = new File(output);
            if (!this.output.exists()) {
                this.output.mkdirs();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void generate(Dialect dialect) {
        String s = this.output.getAbsolutePath() + "/ddl_" + dialect.name().toLowerCase() + ".sql";
        this.cfg.setProperty("hibernate.dialect", dialect.getDialectClass());
        SchemaExport export = new SchemaExport((Configuration)this.cfg);
        export.setDelimiter(";");
        export.setOutputFile(s);
        export.setFormat(true);
        export.setHaltOnError(true);
        export.execute(true, false, false, false);
        System.out.println("==================");
        System.out.println("DDL: " + s);
        System.out.println("==================");
    }

    public static void main(String[] args) throws Exception {
        String outputDir = args.length > 0 ? args[0] : System.getProperty("user.home");
        System.out.println("Output Dir: " + outputDir);
        SchemaGenerator gen = new SchemaGenerator("org.jboss.bpm.monitor.model.bpaf", outputDir);
        gen.generate(Dialect.MYSQL);
        gen.generate(Dialect.ORACLE);
        gen.generate(Dialect.HSQL);
        gen.generate(Dialect.POSTGRES);
        gen.generate(Dialect.DB2);
        gen.generate(Dialect.DERBY);
        gen.generate(Dialect.SQLSERVER);
    }

    private List<Class<?>> getClasses(String packageName) throws Exception {
        ArrayList classes = new ArrayList();
        File directory = null;
        try {
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            String path = packageName.replace('.', '/');
            URL resource = cld.getResource(path);
            if (resource == null) {
                throw new ClassNotFoundException("No resource for " + path);
            }
            directory = new File(resource.getFile());
        }
        catch (NullPointerException x) {
            throw new ClassNotFoundException(packageName + " (" + directory + ") does not appear to be a valid package");
        }
        if (directory.exists()) {
            String[] files = directory.list();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".class")) continue;
                classes.add(Class.forName(packageName + '.' + files[i].substring(0, files[i].length() - 6)));
            }
        } else {
            throw new ClassNotFoundException(packageName + " is not a valid package");
        }
        return classes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Dialect {
        DB2("org.hibernate.dialect.DB2Dialect"),
        DERBY("org.hibernate.dialect.DerbyDialect"),
        POSTGRES("org.hibernate.dialect.PostgreSQLDialect"),
        SQLSERVER("org.hibernate.dialect.SQLServerDialect"),
        ORACLE("org.hibernate.dialect.Oracle10gDialect"),
        MYSQL("org.hibernate.dialect.MySQLDialect"),
        HSQL("org.hibernate.dialect.HSQLDialect");

        private String dialectClass;

        private Dialect(String dialectClass) {
            this.dialectClass = dialectClass;
        }

        public String getDialectClass() {
            return this.dialectClass;
        }
    }
}

