/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.plugin.common.IoUtils;
import org.jboss.as.plugin.common.ServerOperations;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public class Commands {
    @Parameter
    private boolean batch;
    @Parameter
    private List<String> commands = new ArrayList<String>();
    @Parameter
    private List<File> scripts = new ArrayList<File>();

    public boolean isBatch() {
        return this.batch;
    }

    public boolean hasCommands() {
        return this.commands != null && !this.commands.isEmpty();
    }

    public boolean hasScripts() {
        return this.scripts != null && !this.scripts.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(ModelControllerClient client) throws IOException {
        boolean hasCommands = this.hasCommands();
        boolean hasScripts = this.hasScripts();
        if (hasCommands || hasScripts) {
            NonClosingModelControllerClient c = new NonClosingModelControllerClient(client);
            CommandContext ctx = Commands.create(c);
            try {
                if (this.isBatch()) {
                    this.executeBatch(ctx);
                } else {
                    this.executeCommands(ctx);
                }
                this.executeScripts(ctx);
            }
            finally {
                ctx.terminateSession();
                ctx.bindClient(null);
            }
        }
    }

    private void executeScripts(CommandContext ctx) throws IOException {
        for (File script : this.scripts) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(script), "UTF-8"));
                String line = reader.readLine();
                while (!ctx.isTerminated() && line != null) {
                    try {
                        ctx.handle(line.trim());
                    }
                    catch (CommandFormatException e) {
                        throw new IllegalArgumentException(String.format("Command '%s' is invalid. %s", line, e.getLocalizedMessage()), e);
                    }
                    catch (CommandLineException e) {
                        throw new IllegalArgumentException(String.format("Command execution failed for command '%s'. %s", line, e.getLocalizedMessage()), e);
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                try {
                    throw new IllegalStateException("Failed to process file '" + script.getAbsolutePath() + "'", e);
                }
                catch (Throwable throwable) {
                    IoUtils.safeClose(reader);
                    throw throwable;
                }
            }
            IoUtils.safeClose(reader);
        }
    }

    private void executeCommands(CommandContext ctx) throws IOException {
        for (String cmd : this.commands) {
            try {
                ctx.handle(cmd);
            }
            catch (CommandFormatException e) {
                throw new IllegalArgumentException(String.format("Command '%s' is invalid. %s", cmd, e.getLocalizedMessage()), e);
            }
            catch (CommandLineException e) {
                throw new IllegalArgumentException(String.format("Command execution failed for command '%s'. %s", cmd, e.getLocalizedMessage()), e);
            }
        }
    }

    private void executeBatch(CommandContext ctx) throws IOException {
        BatchManager batchManager = ctx.getBatchManager();
        if (batchManager.activateNewBatch()) {
            Batch batch = batchManager.getActiveBatch();
            for (String cmd : this.commands) {
                try {
                    batch.add(ctx.toBatchedCommand(cmd));
                }
                catch (CommandFormatException e) {
                    throw new IllegalArgumentException(String.format("Command '%s' is invalid. %s", cmd, e.getLocalizedMessage()), e);
                }
            }
            ModelNode result = ctx.getModelControllerClient().execute(batch.toRequest());
            if (!ServerOperations.isSuccessfulOutcome((ModelNode)result)) {
                throw new IllegalArgumentException(ServerOperations.getFailureDescriptionAsString(result));
            }
        }
    }

    public static CommandContext create(ModelControllerClient client) {
        CommandContext commandContext;
        try {
            commandContext = CommandContextFactory.getInstance().newCommandContext();
            commandContext.bindClient(client);
        }
        catch (CliInitializationException e) {
            throw new IllegalStateException("Failed to initialize CLI context", e);
        }
        return commandContext;
    }

    static class NonClosingModelControllerClient
    implements ModelControllerClient {
        private final ModelControllerClient delegate;

        NonClosingModelControllerClient(ModelControllerClient delegate) {
            this.delegate = delegate;
        }

        public ModelNode execute(ModelNode operation) throws IOException {
            return this.delegate.execute(operation);
        }

        public ModelNode execute(Operation operation) throws IOException {
            return this.delegate.execute(operation);
        }

        public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
            return this.delegate.execute(operation, messageHandler);
        }

        public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
            return this.delegate.execute(operation, messageHandler);
        }

        public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
            return this.delegate.executeAsync(operation, messageHandler);
        }

        public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
            return this.delegate.executeAsync(operation, messageHandler);
        }

        public void close() throws IOException {
        }
    }
}

