/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.jboss.arquillian.test.spi.ArquillianProxyException;
import org.jboss.arquillian.test.spi.SecurityActions;

public class ExceptionProxy
implements Externalizable {
    private static final long serialVersionUID = 2321010311438950147L;
    private String className;
    private String message;
    private StackTraceElement[] trace;
    private ExceptionProxy causeProxy;
    private Throwable cause;
    private Throwable original;
    private Throwable serializationProcessException = null;

    public ExceptionProxy() {
    }

    public ExceptionProxy(Throwable throwable) {
        this.className = throwable.getClass().getName();
        this.message = throwable.getMessage();
        this.trace = throwable.getStackTrace();
        this.causeProxy = ExceptionProxy.createForException(throwable.getCause());
        this.original = throwable;
    }

    public boolean hasException() {
        return this.className != null;
    }

    public Throwable createException() {
        if (!this.hasException()) {
            return null;
        }
        if (this.original != null) {
            return this.original;
        }
        ArquillianProxyException throwable = this.createProxyException("Original exception caused: " + (this.serializationProcessException != null ? this.serializationProcessException.getClass() + ": " + this.serializationProcessException.getMessage() : "Unknown serialization issue"));
        return throwable;
    }

    public ArquillianProxyException createProxyException(String reason) {
        ArquillianProxyException exception = new ArquillianProxyException(this.message, this.className, reason, this.getCause());
        exception.setStackTrace(this.trace);
        return exception;
    }

    public static ExceptionProxy createForException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        return new ExceptionProxy(throwable);
    }

    public Throwable getCause() {
        if (this.cause == null && this.causeProxy != null) {
            this.cause = this.causeProxy.createException();
        }
        return this.cause;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Throwable tmpSerializationProcessException;
        this.className = (String)in.readObject();
        this.message = (String)in.readObject();
        this.trace = (StackTraceElement[])in.readObject();
        this.causeProxy = (ExceptionProxy)in.readObject();
        byte[] originalExceptionData = (byte[])in.readObject();
        if (originalExceptionData != null && originalExceptionData.length > 0) {
            try {
                ByteArrayInputStream originalIn = new ByteArrayInputStream(originalExceptionData);
                ObjectInputStream input = new ObjectInputStream(originalIn);
                this.original = (Throwable)input.readObject();
                if (this.causeProxy != null) {
                    SecurityActions.setFieldValue(Throwable.class, this.original, "cause", this.causeProxy.createException());
                }
            }
            catch (Throwable e) {
                this.serializationProcessException = e;
            }
        }
        if ((tmpSerializationProcessException = (Throwable)in.readObject()) != null) {
            this.serializationProcessException = tmpSerializationProcessException;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.message);
        out.writeObject(this.trace);
        out.writeObject(this.causeProxy);
        byte[] originalBytes = new byte[]{};
        if (this.original != null) {
            try {
                SecurityActions.setFieldValue(Throwable.class, this.original, "cause", null);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                ByteArrayOutputStream originalOut = new ByteArrayOutputStream();
                ObjectOutputStream output = new ObjectOutputStream(originalOut);
                output.writeObject(this.original);
                output.flush();
                originalBytes = originalOut.toByteArray();
            }
            catch (NotSerializableException e) {
                this.serializationProcessException = e;
            }
        }
        out.writeObject(originalBytes);
        out.writeObject(this.serializationProcessException);
    }

    public String toString() {
        return super.toString() + String.format("[class=%s, message=%s],cause = %s", this.className, this.message, this.causeProxy);
    }
}

