/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.window;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.event.AfterDroneEnhanced;
import org.jboss.arquillian.drone.spi.event.AfterDroneInstantiated;
import org.jboss.arquillian.drone.spi.event.DroneEvent;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.window.Validate;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowResizer {
    private static final Logger log = Logger.getLogger(WindowResizer.class.getName());
    static final Pattern DIMENSIONS_PATTERN = Pattern.compile("([0-9]+)x([0-9]+)");
    @Inject
    Instance<DroneContext> droneContext;

    public void resizeBrowserWindow(@Observes AfterDroneInstantiated event) {
        this.resizeWindow((DroneEvent)event);
    }

    public void resizeBrowserWindow(@Observes AfterDroneEnhanced event) {
        this.resizeWindow((DroneEvent)event);
    }

    private void resizeWindow(DroneEvent event) {
        Matcher m;
        DronePoint dronePoint = event.getDronePoint();
        if (!dronePoint.conformsTo(WebDriver.class)) {
            return;
        }
        DroneContext context = (DroneContext)this.droneContext.get();
        WebDriver driver = (WebDriver)context.get(dronePoint).getInstanceAs(WebDriver.class);
        Validate.stateNotNull(context, "DroneContext must not be null");
        WebDriverConfiguration configuration = (WebDriverConfiguration)context.get(dronePoint).getConfigurationAs(WebDriverConfiguration.class);
        Validate.stateNotNull(configuration, "WebDriver configuration must not be null");
        String dimensions = configuration.getDimensions();
        if (dimensions != null && (m = DIMENSIONS_PATTERN.matcher(dimensions)).matches()) {
            int width = Integer.valueOf(m.group(1));
            int height = Integer.valueOf(m.group(2));
            this.safelyResizeWindow(driver, width, height, dronePoint);
        }
    }

    private void safelyResizeWindow(WebDriver driver, int width, int height, DronePoint<?> dronePoint) {
        try {
            driver.manage().window().setSize(new Dimension(width, height));
        }
        catch (WebDriverException e) {
            this.logRequestIgnored(driver, width, height, dronePoint);
        }
        catch (UnsupportedOperationException e) {
            this.logRequestIgnored(driver, width, height, dronePoint);
        }
    }

    private void logRequestIgnored(WebDriver driver, int width, int height, DronePoint<?> dronePoint) {
        log.log(Level.WARNING, "Ignoring request to resize browser window to {2}x{3} for {0}, not supported for {1}", new Object[]{dronePoint, driver.getClass().getName(), width, height});
    }
}

