/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.embedded.mock;

import jakarta.ejb.EnterpriseBean;
import jakarta.ejb.MessageDriven;
import jakarta.ejb.Singleton;
import jakarta.ejb.Stateful;
import jakarta.ejb.Stateless;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jboss.arquillian.container.weld.embedded.mock.MockEjbDescriptor;
import org.jboss.arquillian.container.weld.embedded.mock.Utils;
import org.jboss.weld.ejb.spi.EjbDescriptor;

public class Ejbs {
    private Ejbs() {
    }

    public static Collection<EjbDescriptor<?>> createEjbDescriptors(Iterable<Class<?>> classes) {
        if (!Utils.isClassAccessible("jakarta.ejb.Singleton", Ejbs.class.getClassLoader())) {
            return Collections.emptySet();
        }
        ArrayList ejbs = new ArrayList();
        for (Class<?> ejbClass : Ejbs.findEjbs(classes)) {
            ejbs.add(MockEjbDescriptor.of(ejbClass));
        }
        return ejbs;
    }

    private static Iterable<Class<?>> findEjbs(Iterable<Class<?>> classes) {
        HashSet ejbs = new HashSet();
        for (Class<?> clazz : classes) {
            if (!clazz.isAnnotationPresent(Stateless.class) && !clazz.isAnnotationPresent(Stateful.class) && !clazz.isAnnotationPresent(MessageDriven.class) && !clazz.isAnnotationPresent(Singleton.class) && !EnterpriseBean.class.isAssignableFrom(clazz)) continue;
            ejbs.add(clazz);
        }
        return ejbs;
    }
}

