/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.tomcat.managed;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.tomcat.AdditionalJavaOptionsParser;
import org.jboss.arquillian.container.tomcat.ProtocolMetadataParser;
import org.jboss.arquillian.container.tomcat.ShrinkWrapUtil;
import org.jboss.arquillian.container.tomcat.TomcatConfiguration;
import org.jboss.arquillian.container.tomcat.TomcatManager;
import org.jboss.arquillian.container.tomcat.TomcatManagerCommandSpec;
import org.jboss.arquillian.container.tomcat.Validate;
import org.jboss.arquillian.container.tomcat.managed.TomcatManagedConfiguration;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

abstract class TomcatManagedContainer
implements DeployableContainer<TomcatManagedConfiguration> {
    private static final Logger log = Logger.getLogger(TomcatManagedContainer.class.getName());
    private final TomcatManagerCommandSpec tomcatManagerCommandSpec;
    private final ProtocolDescription protocolDescription;
    private TomcatManagedConfiguration configuration;
    private TomcatManager<? extends TomcatManagedConfiguration> manager;
    private Thread shutdownThread;
    private Process startupProcess;

    TomcatManagedContainer(ProtocolDescription protocolDescription, TomcatManagerCommandSpec tomcatManagerCommandSpec) {
        this.protocolDescription = protocolDescription;
        this.tomcatManagerCommandSpec = tomcatManagerCommandSpec;
    }

    public Class<TomcatManagedConfiguration> getConfigurationClass() {
        return TomcatManagedConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return this.protocolDescription;
    }

    public void setup(TomcatManagedConfiguration configuration) {
        this.configuration = configuration;
        this.manager = new TomcatManager((TomcatConfiguration)configuration, this.tomcatManagerCommandSpec);
    }

    public void start() throws LifecycleException {
        if (this.manager.isRunning()) {
            throw new LifecycleException("The server is already running! Managed containers does not support connecting to running server instances due to the possible harmful effect of connecting to the wrong server. Please stop server before running or change to another type of container.\nTo disable this check and allow Arquillian to connect to a running server, set allowConnectingToRunningServer to true in the container configuration");
        }
        try {
            String CATALINA_HOME = this.configuration.getCatalinaHome();
            String CATALINA_BASE = this.configuration.getCatalinaBase();
            String ADDITIONAL_JAVA_OPTS = this.configuration.getJavaVmArguments();
            if (CATALINA_BASE == null) {
                CATALINA_BASE = CATALINA_HOME;
            }
            String absoluteCatalinaHomePath = new File(CATALINA_HOME).getAbsolutePath();
            String absoluteCatalinaBasePath = new File(CATALINA_BASE).getAbsolutePath();
            String javaCommand = this.getJavaCommand();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(javaCommand);
            String seperator = File.separator;
            cmd.add("-Djava.util.logging.config.file=" + absoluteCatalinaBasePath + seperator + "conf" + seperator + this.configuration.getLoggingProperties());
            cmd.add("-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager");
            cmd.add("-Dcom.sun.management.jmxremote.port=" + this.configuration.getJmxPort());
            cmd.add("-Dcom.sun.management.jmxremote.ssl=false");
            cmd.add("-Dcom.sun.management.jmxremote.authenticate=false");
            cmd.addAll(AdditionalJavaOptionsParser.parse((String)ADDITIONAL_JAVA_OPTS));
            String CLASS_PATH = absoluteCatalinaHomePath + seperator + "bin" + seperator + "bootstrap.jar" + File.pathSeparator;
            CLASS_PATH = CLASS_PATH + absoluteCatalinaHomePath + seperator + "bin" + seperator + "tomcat-juli.jar";
            cmd.add("-classpath");
            cmd.add(CLASS_PATH);
            File endorsed = new File(absoluteCatalinaHomePath + seperator + "endorsed");
            if (endorsed.exists()) {
                cmd.add("-Djava.endorsed.dirs=" + endorsed.getAbsolutePath());
            }
            cmd.add("-Dcatalina.base=" + absoluteCatalinaBasePath);
            cmd.add("-Dcatalina.home=" + absoluteCatalinaHomePath);
            cmd.add("-Djava.io.tmpdir=" + absoluteCatalinaBasePath + seperator + "temp");
            cmd.add("org.apache.catalina.startup.Bootstrap");
            cmd.add("-config");
            cmd.add(absoluteCatalinaBasePath + seperator + "conf" + seperator + this.configuration.getServerConfig());
            cmd.add("start");
            ProcessBuilder startupProcessBuilder = new ProcessBuilder(cmd);
            startupProcessBuilder.redirectErrorStream(true);
            startupProcessBuilder.directory(new File(this.configuration.getCatalinaHome() + "/bin"));
            log.info("Starting Tomcat with: " + ((Object)cmd).toString());
            this.startupProcess = startupProcessBuilder.start();
            new Thread(new ConsoleConsumer(this.configuration.isOutputToConsole())).start();
            final Process proc = this.startupProcess;
            this.shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (proc != null) {
                        proc.destroy();
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
            long startupTimeout = this.configuration.getStartupTimeoutInSeconds();
            long timeout = startupTimeout * 1000L;
            boolean serverAvailable = false;
            while (timeout > 0L && !serverAvailable) {
                serverAvailable = this.manager.isRunning();
                if (serverAvailable) continue;
                Thread.sleep(100L);
                timeout -= 100L;
            }
            if (!serverAvailable) {
                this.destroystartupProcess();
                throw new TimeoutException(String.format("Managed server was not started within [%d] s", startupTimeout));
            }
        }
        catch (Exception ex) {
            throw new LifecycleException("Could not start container", (Throwable)ex);
        }
    }

    public void stop() throws LifecycleException {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.startupProcess != null) {
                this.startupProcess.destroy();
                this.startupProcess.waitFor();
                this.startupProcess = null;
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        Validate.notNull(archive, (String)"Archive must not be null");
        String archiveName = this.manager.normalizeArchiveName(archive.getName());
        URL archiveURL = ShrinkWrapUtil.toURL(archive);
        try {
            this.manager.deploy("/" + archiveName, archiveURL);
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to deploy an archive " + archive.getName(), (Throwable)e);
        }
        ProtocolMetadataParser parser = new ProtocolMetadataParser((TomcatConfiguration)this.configuration);
        return parser.retrieveContextServletInfo(archiveName);
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        Validate.notNull(archive, (String)"Archive must not be null");
        String archiveName = this.manager.normalizeArchiveName(archive.getName());
        try {
            this.manager.undeploy("/" + archiveName);
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to undeploy an archive " + archive.getName(), (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    private int destroystartupProcess() {
        if (this.startupProcess == null) {
            return 0;
        }
        this.startupProcess.destroy();
        try {
            return this.startupProcess.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    String getJavaCommand() {
        if (this.configuration == null) {
            throw new IllegalStateException("setup not called");
        }
        return this.configuration.getJavaHome() + File.separator + "bin" + File.separator + "java";
    }

    private class ConsoleConsumer
    implements Runnable {
        private final boolean writeOutput;

        ConsoleConsumer(boolean writeOutput) {
            this.writeOutput = writeOutput;
        }

        @Override
        public void run() {
            InputStream stream = TomcatManagedContainer.this.startupProcess.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    if (!this.writeOutput) continue;
                    System.out.println(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

