/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CtMember;

public class WrapperTransformer {
    private static final byte UNWRAPPED = 0;
    private static final byte WRAPPED = 1;
    private static final byte NOT_PREPARED = 2;
    private static final String WRAPPER_STATUS_ATTRIBUTE = "aop$wrapperStatus$aop";
    protected static final String[] SINGLE_TRANSFORMATION = new String[]{"aop$wrapperStatus$aop"};
    protected static final int SINGLE_TRANSFORMATION_INDEX = 0;
    private String[] transformationsStatus;

    public WrapperTransformer(String[] transformations) {
        if (transformations == SINGLE_TRANSFORMATION) {
            this.transformationsStatus = transformations;
        } else {
            this.transformationsStatus = new String[transformations.length];
            for (int i = 0; i < transformations.length; ++i) {
                this.transformationsStatus[i] = "aop$wrapperStatus$aop$" + transformations[i];
            }
        }
    }

    public void prepareForWrapping(CtMember member, int transformationIndex) {
        if (this.getWrapperStatusAttribute(member, transformationIndex) != 2) {
            throw new RuntimeException("Member already prepared:" + member);
        }
        this.setWrapperStatusAttribute(member, transformationIndex, (byte)0);
    }

    public void wrap(CtMember member, int transformationIndex) {
        byte wrapperStatus = this.getWrapperStatusAttribute(member, transformationIndex);
        if (wrapperStatus != 0) {
            String errorMessage = "Member not unwrapped: " + member.getName() + "." + member.getDeclaringClass().getName();
            errorMessage = errorMessage + "\nMember status: ";
            errorMessage = errorMessage + (wrapperStatus == 2 ? "NOT_PREPARED" : "WRAPPED");
            throw new RuntimeException(errorMessage);
        }
        this.setWrapperStatusAttribute(member, transformationIndex, (byte)1);
    }

    public void unwrap(CtMember member, int transformationIndex) {
        byte wrapperStatus = this.getWrapperStatusAttribute(member, transformationIndex);
        if (wrapperStatus != 1) {
            String errorMessage = "Member not wrapped: " + member.getName() + "." + member.getDeclaringClass().getName();
            errorMessage = errorMessage + "\nMember status: ";
            errorMessage = errorMessage + (wrapperStatus == 2 ? "NOT_PREPARED" : "UNWRAPPED");
            throw new RuntimeException(errorMessage);
        }
        this.setWrapperStatusAttribute(member, transformationIndex, (byte)0);
    }

    public boolean isNotPrepared(CtMember member, int transformationIndex) {
        byte wrapperStatus = this.getWrapperStatusAttribute(member, transformationIndex);
        return wrapperStatus == 2;
    }

    public boolean isWrapped(CtMember member, int transformationIndex) {
        byte wrapperStatus = this.getWrapperStatusAttribute(member, transformationIndex);
        return wrapperStatus == 1;
    }

    private byte getWrapperStatusAttribute(CtMember member, int transformationIndex) {
        byte[] attributeValue = member.getAttribute(this.transformationsStatus[transformationIndex]);
        if (attributeValue == null) {
            return 2;
        }
        return attributeValue[0];
    }

    private void setWrapperStatusAttribute(CtMember member, int transformationIndex, byte status) {
        member.setAttribute(this.transformationsStatus[transformationIndex], new byte[]{status});
    }
}

