/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.aop.asintegration.jboss5;

import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classpool.plugins.jbosscl.DomainRegistry;
import org.jboss.logging.Logger;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class VFSClassLoaderScopingPolicy implements AOPClassLoaderScopingPolicyWithRegistry
{
   static Logger log = Logger.getLogger(VFSClassLoaderScopingPolicy.class);
   
   /** The raw DomainRegistry coming from the classpools */
   private DomainRegistry domainRegistry;
   
   /** The aop domain registry  */
   private AOPDomainRegistry registry = null;
   
   /**
    * Sets the raw DomainRegistry coming from classpools
    * 
    * @param domainRegistry The classpool DomainRegistry
    */
   public void setDomainRegistry(DomainRegistry domainRegistry)
   {
      this.domainRegistry = domainRegistry;
   }
   
   public AOPDomainRegistry getRegistry()
   {
      return registry;
   }

   public void registerClassLoader(Module module, ClassLoader loader)
   {
      AspectManager.instance().registerClassLoader(loader); //Ends up in classpool factory create method
   }
   
   public Domain getDomain(ClassLoader classLoader, AspectManager parent)
   {
      //Check the stored domains
      Domain domain = registry.getRegisteredDomain(classLoader);
      if (domain != null)
      {
         return domain;
      }
      
      return null;
   }

   public Domain getTopLevelDomain(AspectManager parent)
   {
      Thread.currentThread().getContextClassLoader();
      return null;
   }
   
   public void start()
   {
      if (domainRegistry == null)
      {
         throw new IllegalStateException("Null registry");
      }
      registry = new AOPVFSClassLoaderDomainRegistry(domainRegistry);
   }
}
   
