/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.configuration.Keywords;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Meta {
    public static final Meta EMPTY = new Meta();
    public static final String BLANK = "";
    public static final String SPACE = " ";
    private final Properties properties;

    public Meta() {
        this(new Properties());
    }

    public Meta(Properties properties) {
        this.properties = properties;
    }

    public Meta(List<String> properties) {
        this.properties = new Properties();
        this.parse(properties);
    }

    private void parse(List<String> propertiesAsString) {
        for (String propertyAsString : new HashSet<String>(propertiesAsString)) {
            Property property = new Property(propertyAsString);
            this.properties.setProperty(property.getName(), property.getValue());
        }
    }

    public Set<String> getPropertyNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (Object key : this.properties.keySet()) {
            names.add((String)key);
        }
        return names;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public String getProperty(String name) {
        String value = this.properties.getProperty(name);
        if (value == null) {
            return BLANK;
        }
        return value;
    }

    public Meta inheritFrom(Meta meta) {
        return this.inherit(this, meta);
    }

    private Meta inherit(Meta child, Meta parent) {
        HashSet<String> names = new HashSet<String>(child.getPropertyNames());
        names.addAll(parent.getPropertyNames());
        Properties inherited = new Properties();
        for (String name : names) {
            if (child.hasProperty(name)) {
                inherited.put(name, child.getProperty(name));
                continue;
            }
            inherited.put(name, parent.getProperty(name));
        }
        return new Meta(inherited);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public String asString(Keywords keywords) {
        StringBuffer sb = new StringBuffer();
        for (String name : this.getPropertyNames()) {
            sb.append(keywords.metaProperty()).append(name).append(SPACE).append(this.getProperty(name)).append(SPACE);
        }
        return sb.toString().trim();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static Meta createMeta(String meta, Keywords keywords) {
        ArrayList<String> properties = new ArrayList<String>();
        for (String property : meta.split(keywords.metaProperty())) {
            String beforeIgnorable;
            if (!StringUtils.isNotBlank((String)property) || !StringUtils.isNotBlank((String)(beforeIgnorable = StringUtils.substringBefore((String)property, (String)keywords.ignorable())))) continue;
            properties.add(beforeIgnorable);
        }
        return new Meta(properties);
    }

    public static class Property {
        private String propertyAsString;
        private String name;
        private String value;

        public Property(String propertyAsString) {
            this.propertyAsString = propertyAsString.trim();
            this.parse();
        }

        private void parse() {
            this.name = StringUtils.substringBefore((String)this.propertyAsString, (String)Meta.SPACE).trim();
            this.value = StringUtils.substringAfter((String)this.propertyAsString, (String)Meta.SPACE).trim();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

