/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.SelectorUtils;
import org.jbehave.core.io.CodeLocations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileScanner {
    private URL jarURL;
    private List<String> includes;
    private List<String> excludes;

    public JarFileScanner(String jarPath, String includes, String excludes) {
        this(jarPath, Arrays.asList(includes), Arrays.asList(excludes));
    }

    public JarFileScanner(String jarPath, List<String> includes, List<String> excludes) {
        this(CodeLocations.codeLocationFromPath(jarPath), includes, excludes);
    }

    public JarFileScanner(URL jarURL, String includes, String excludes) {
        this(jarURL, Arrays.asList(includes), Arrays.asList(excludes));
    }

    public JarFileScanner(URL jarURL, List<String> includes, List<String> excludes) {
        this.jarURL = jarURL;
        this.includes = includes != null ? this.toLocalPath(includes) : Arrays.asList(new String[0]);
        this.excludes = excludes != null ? this.toLocalPath(excludes) : Arrays.asList(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> scan() {
        ArrayList<String> arrayList;
        JarFile jar = new JarFile(this.jarURL.getFile());
        try {
            ArrayList<String> result = new ArrayList<String>();
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                boolean match;
                JarEntry entry = en.nextElement();
                String path = entry.getName();
                boolean bl = match = this.includes.size() == 0;
                if (!match) {
                    for (String pattern : this.includes) {
                        if (!this.patternMatches(pattern, path)) continue;
                        match = true;
                        break;
                    }
                }
                if (match) {
                    for (String pattern : this.excludes) {
                        if (!this.patternMatches(pattern, path)) continue;
                        match = false;
                        break;
                    }
                }
                if (!match) continue;
                result.add(path);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                jar.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        jar.close();
        return arrayList;
    }

    private List<String> toLocalPath(List<String> patternList) {
        ArrayList<String> transformed = new ArrayList<String>(patternList);
        CollectionUtils.transform(transformed, (Transformer)new Transformer(){

            public Object transform(Object input) {
                String pattern = (String)input;
                return pattern != null ? pattern.replace('/', File.separatorChar) : null;
            }
        });
        return transformed;
    }

    private boolean patternMatches(String pattern, String path) {
        if (StringUtils.isBlank((String)pattern)) {
            return false;
        }
        String localPath = path.replace('/', File.separatorChar);
        return SelectorUtils.matchPath((String)pattern, (String)localPath);
    }
}

