/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.metamodel.annotation.DiffIgnore;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.PropertiesFilter;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.scanner.ClassScan;
import org.javers.core.metamodel.type.IgnoredType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedClass;
import org.javers.core.metamodel.type.ManagedPropertiesFilter;
import org.javers.core.metamodel.type.TypeMapper;

class ManagedClassFactory {
    private final TypeMapper typeMapper;

    public ManagedClassFactory(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    ManagedClass create(ClientsClassDefinition def, ClassScan scan) {
        List<JaversProperty> allProperties = this.convert(scan.getProperties());
        ManagedPropertiesFilter managedPropertiesFilter = new ManagedPropertiesFilter(def.getBaseJavaClass(), allProperties, def.getPropertiesFilter());
        return this.create(def.getBaseJavaClass(), allProperties, managedPropertiesFilter);
    }

    ManagedClass createFromPrototype(Class<?> baseJavaClass, ClassScan scan, ManagedPropertiesFilter prototypePropertiesFilter) {
        List<JaversProperty> allProperties = this.convert(scan.getProperties());
        ManagedPropertiesFilter managedPropertiesFilter = new ManagedPropertiesFilter(baseJavaClass, allProperties, PropertiesFilter.empty());
        ManagedPropertiesFilter managedPropertiesFilterWithPrototypeFilter = managedPropertiesFilter.add(prototypePropertiesFilter);
        return this.create(baseJavaClass, allProperties, managedPropertiesFilterWithPrototypeFilter);
    }

    private ManagedClass create(Class<?> baseJavaClass, List<JaversProperty> allProperties, ManagedPropertiesFilter propertiesFilter) {
        List<JaversProperty> filtered = propertiesFilter.filterProperties(allProperties);
        filtered = this.filterIgnoredType(filtered, baseJavaClass);
        return new ManagedClass(baseJavaClass, filtered, Lists.positiveFilter(allProperties, p -> p.looksLikeId()), propertiesFilter);
    }

    private List<JaversProperty> convert(List<Property> properties) {
        return Lists.transform(properties, p -> {
            if (this.typeMapper.contains(p.getGenericType())) {
                JaversType javersType = this.typeMapper.getJaversType(p.getGenericType());
                return new JaversProperty(() -> javersType, (Property)p);
            }
            return new JaversProperty(() -> this.typeMapper.getJaversType(p.getGenericType()), (Property)p);
        });
    }

    private List<JaversProperty> filterIgnoredType(List<JaversProperty> properties, Class<?> currentClass) {
        return Lists.negativeFilter(properties, property -> {
            if (property.getRawType() == currentClass) {
                return false;
            }
            if (this.typeMapper.contains(property.getRawType()) || this.typeMapper.contains(property.getGenericType())) {
                return this.typeMapper.getJaversType(property.getRawType()) instanceof IgnoredType;
            }
            return ReflectionUtil.isAnnotationPresentInHierarchy(property.getRawType(), DiffIgnore.class);
        });
    }
}

