/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.jql.AnyDomainObjectFilter;
import org.javers.repository.jql.ClassFilter;
import org.javers.repository.jql.Filter;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.IdFilter;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.ValueObjectIdDTO;
import org.javers.repository.jql.VoOwnerFilter;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class QueryBuilder {
    private static final int DEFAULT_LIMIT = 100;
    private static final int DEFAULT_SKIP = 0;
    private final List<Filter> filters = new ArrayList<Filter>();
    private final QueryParamsBuilder queryParamsBuilder;

    private QueryBuilder(Filter initialFilter) {
        this.addFilter(initialFilter);
        this.queryParamsBuilder = QueryParamsBuilder.withLimit(100).skip(0);
    }

    public static QueryBuilder anyDomainObject() {
        return new QueryBuilder(new AnyDomainObjectFilter());
    }

    public static QueryBuilder byClass(Class requiredClass) {
        return new QueryBuilder(new ClassFilter(requiredClass));
    }

    public static QueryBuilder byInstanceId(Object localId, Class entityClass) {
        Validate.argumentsAreNotNull(localId, entityClass);
        return new QueryBuilder(new IdFilter(InstanceIdDTO.instanceId(localId, entityClass)));
    }

    public static QueryBuilder byValueObject(Class ownerEntityClass, String path) {
        Validate.argumentsAreNotNull(ownerEntityClass, path);
        return new QueryBuilder(new VoOwnerFilter(ownerEntityClass, path));
    }

    public static QueryBuilder byValueObjectId(Object ownerLocalId, Class ownerEntityClass, String path) {
        Validate.argumentsAreNotNull(ownerEntityClass, ownerLocalId, path);
        return new QueryBuilder(new IdFilter(ValueObjectIdDTO.valueObjectId(ownerLocalId, ownerEntityClass, path)));
    }

    @Deprecated
    public static QueryBuilder byGlobalIdDTO(GlobalIdDTO globalId) {
        Validate.argumentIsNotNull(globalId);
        return new QueryBuilder(new IdFilter(globalId));
    }

    public QueryBuilder andProperty(String propertyName) {
        Validate.argumentIsNotNull(propertyName);
        this.queryParamsBuilder.changedProperty(propertyName);
        return this;
    }

    public QueryBuilder withNewObjectChanges(boolean newObjectChanges) {
        this.queryParamsBuilder.newObjectChanges(true);
        return this;
    }

    public QueryBuilder withNewObjectChanges() {
        this.queryParamsBuilder.newObjectChanges(true);
        return this;
    }

    public QueryBuilder withChildValueObjects(boolean aggregate) {
        this.queryParamsBuilder.withChildValueObjects(aggregate);
        return this;
    }

    public QueryBuilder withChildValueObjects() {
        this.queryParamsBuilder.withChildValueObjects(true);
        return this;
    }

    public QueryBuilder limit(int limit) {
        this.queryParamsBuilder.limit(limit);
        return this;
    }

    public QueryBuilder skip(int skip) {
        this.queryParamsBuilder.skip(skip);
        return this;
    }

    public QueryBuilder from(LocalDateTime from) {
        this.queryParamsBuilder.from(from);
        return this;
    }

    public QueryBuilder from(LocalDate fromDate) {
        return this.from(fromDate.toLocalDateTime(LocalTime.MIDNIGHT));
    }

    public QueryBuilder to(LocalDateTime to) {
        this.queryParamsBuilder.to(to);
        return this;
    }

    public QueryBuilder to(LocalDate toDate) {
        return this.to(toDate.toLocalDateTime(LocalTime.MIDNIGHT));
    }

    public QueryBuilder withCommitId(CommitId commitId) {
        Validate.argumentIsNotNull(commitId);
        this.queryParamsBuilder.commitId(commitId);
        return this;
    }

    public QueryBuilder withCommitId(BigDecimal commitId) {
        Validate.argumentIsNotNull(commitId);
        this.queryParamsBuilder.commitId(CommitId.valueOf(commitId));
        return this;
    }

    public QueryBuilder withCommitProperty(String name, String value) {
        Validate.argumentsAreNotNull(name, value);
        this.queryParamsBuilder.commitProperty(name, value);
        return this;
    }

    public QueryBuilder withVersion(long version) {
        Validate.argumentCheck(version > 0L, "Version is not a positive number.");
        this.queryParamsBuilder.version(version);
        return this;
    }

    public QueryBuilder byAuthor(String author) {
        Validate.argumentIsNotNull(author);
        this.queryParamsBuilder.author(author);
        return this;
    }

    protected void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    protected List<Filter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public JqlQuery build() {
        if (this.filters.isEmpty()) {
            throw new JaversException(JaversExceptionCode.RUNTIME_EXCEPTION, "empty JqlQuery");
        }
        return new JqlQuery(this.getFilters(), this.queryParamsBuilder.build());
    }
}

