/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbcx4;

import java.lang.reflect.Method;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.javasimon.jdbcx4.AbstractSimonDataSource;
import org.javasimon.jdbcx4.SimonXAConnection;

public final class SimonXADataSource
extends AbstractSimonDataSource
implements XADataSource {
    private XADataSource ds;

    private XADataSource datasource() throws SQLException {
        if (this.ds == null) {
            Object o;
            if (this.realDataSourceClassName == null || this.realDataSourceClassName.length() == 0) {
                throw new SQLException("Property realDataSourceClassName is not set");
            }
            try {
                o = Class.forName(this.realDataSourceClassName).newInstance();
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
            if (o instanceof XADataSource) {
                this.ds = (XADataSource)o;
                try {
                    for (Method m : this.ds.getClass().getMethods()) {
                        String methodName = m.getName();
                        if (methodName.equalsIgnoreCase("setUser")) {
                            m.invoke((Object)this.ds, this.user);
                            continue;
                        }
                        if (methodName.equalsIgnoreCase("setPassword")) {
                            m.invoke((Object)this.ds, this.password);
                            continue;
                        }
                        if (!methodName.equalsIgnoreCase("setUrl")) continue;
                        m.invoke((Object)this.ds, this.url);
                    }
                }
                catch (Exception e) {
                    throw new SQLException(e.getMessage());
                }
                this.ds.setLoginTimeout(this.loginTimeout);
            } else {
                throw new SQLException("Class in realDataSourceClassName is not a XADataSource");
            }
        }
        return this.ds;
    }

    public XAConnection getXAConnection() throws SQLException {
        return new SimonXAConnection(this.datasource().getXAConnection(), this.prefix);
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return new SimonXAConnection(this.datasource().getXAConnection(user, password), this.prefix);
    }
}

