/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbcx4;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.javasimon.jdbc4.SimonConnection;
import org.javasimon.jdbc4.WrapperSupport;
import org.javasimon.jdbcx4.AbstractSimonDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimonDataSource
extends AbstractSimonDataSource
implements DataSource {
    private DataSource ds;
    private WrapperSupport<DataSource> wrapperSupport;

    private DataSource datasource() throws SQLException {
        if (this.ds == null) {
            Object o;
            if (this.realDataSourceClassName == null || this.realDataSourceClassName.length() == 0) {
                throw new SQLException("Property realDataSourceClassName is not set");
            }
            try {
                o = Class.forName(this.realDataSourceClassName).newInstance();
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
            if (o instanceof DataSource) {
                this.ds = (DataSource)o;
                try {
                    for (Method m : this.ds.getClass().getMethods()) {
                        String methodName = m.getName();
                        if (methodName.equalsIgnoreCase("setUser")) {
                            m.invoke((Object)this.ds, this.user);
                            continue;
                        }
                        if (methodName.equalsIgnoreCase("setPassword")) {
                            m.invoke((Object)this.ds, this.password);
                            continue;
                        }
                        if (!methodName.equalsIgnoreCase("setUrl")) continue;
                        m.invoke((Object)this.ds, this.url);
                    }
                }
                catch (Exception e) {
                    throw new SQLException(e.getMessage());
                }
                this.ds.setLogWriter(this.logWriter);
                this.ds.setLoginTimeout(this.loginTimeout);
                this.wrapperSupport = new WrapperSupport<DataSource>(this.ds, DataSource.class);
            } else {
                throw new SQLException("Class in realDataSourceClassName is not a DataSource");
            }
        }
        return this.ds;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new SimonConnection(this.datasource().getConnection(), this.prefix);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        return new SimonConnection(this.datasource().getConnection(user, password), this.prefix);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.wrapperSupport.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.wrapperSupport.isWrapperFor(iface);
    }
}

