/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbcx4;

import java.lang.reflect.Method;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.javasimon.jdbcx4.AbstractSimonDataSource;
import org.javasimon.jdbcx4.SimonPooledConnection;

public final class SimonConnectionPoolDataSource
extends AbstractSimonDataSource
implements ConnectionPoolDataSource {
    private ConnectionPoolDataSource ds;

    private ConnectionPoolDataSource datasource() throws SQLException {
        if (this.ds == null) {
            Object o;
            if (this.realDataSourceClassName == null || this.realDataSourceClassName.length() == 0) {
                throw new SQLException("Property realDataSourceClassName is not set");
            }
            try {
                o = Class.forName(this.realDataSourceClassName).newInstance();
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
            if (o instanceof ConnectionPoolDataSource) {
                this.ds = (ConnectionPoolDataSource)o;
                try {
                    for (Method m : this.ds.getClass().getMethods()) {
                        String methodName = m.getName();
                        if (methodName.equalsIgnoreCase("setUser")) {
                            m.invoke((Object)this.ds, this.user);
                            continue;
                        }
                        if (methodName.equalsIgnoreCase("setPassword")) {
                            m.invoke((Object)this.ds, this.password);
                            continue;
                        }
                        if (!methodName.equalsIgnoreCase("setUrl")) continue;
                        m.invoke((Object)this.ds, this.url);
                    }
                }
                catch (Exception e) {
                    throw new SQLException(e.getMessage());
                }
                this.ds.setLoginTimeout(this.loginTimeout);
            } else {
                throw new SQLException("Class in realDataSourceClassName is not a ConnectionPoolDataSource");
            }
        }
        return this.ds;
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return new SimonPooledConnection(this.datasource().getPooledConnection(), this.prefix);
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new SimonPooledConnection(this.datasource().getPooledConnection(user, password), this.prefix);
    }
}

