/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbc4;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.javasimon.jdbc4.SimonConnection;

public final class Driver
implements java.sql.Driver {
    public static final String REAL_DRIVER = "simon_real_drv";
    public static final String DEFAULT_PREFIX = "org.javasimon.jdbc";
    public static final String PREFIX = "simon_prefix";
    private final Properties drivers = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Driver() {
        try {
            InputStream stream = null;
            try {
                stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/javasimon/jdbc4/drivers.properties");
                this.drivers.load(stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Connection connect(String simonUrl, Properties info) throws SQLException {
        if (!this.acceptsURL(simonUrl)) {
            return null;
        }
        Url url = new Url(simonUrl);
        java.sql.Driver driver = this.getRealDriver(url, info);
        return new SimonConnection(driver.connect(url.getRealUrl(), info), url.getPrefix());
    }

    private java.sql.Driver getRealDriver(Url url, Properties info) throws SQLException {
        java.sql.Driver drv = null;
        try {
            drv = DriverManager.getDriver(url.getRealUrl());
        }
        catch (SQLException e) {
            // empty catch block
        }
        if (drv == null && info != null && info.keySet().contains(REAL_DRIVER)) {
            drv = this.registerDriver(info.getProperty(REAL_DRIVER));
        }
        if (drv == null && url.getDriverId() != null) {
            drv = this.registerDriver(this.drivers.getProperty(url.getDriverId()));
        }
        if (drv == null && url.getRealDriver() != null) {
            drv = this.registerDriver(url.getRealDriver());
        }
        if (drv == null) {
            throw new SQLException("Real driver is not registered and can't determine real driver class name for registration.");
        }
        return drv;
    }

    private java.sql.Driver registerDriver(String name) throws SQLException {
        try {
            java.sql.Driver d = (java.sql.Driver)Class.forName(name).newInstance();
            DriverManager.registerDriver(d);
            return d;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url != null && url.toLowerCase().startsWith("jdbc:simon");
    }

    public DriverPropertyInfo[] getPropertyInfo(String s, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class Url {
        private static final String SIMON_JDBC = "jdbc:simon";
        private static final int JDBC_URL_FIXED_PREFIX_LEN = 5;
        private String realUrl;
        private String driverId;
        private String realDriver;
        private String prefix;

        Url(String url) {
            int i = url.indexOf(58, 5);
            if (i > -1) {
                this.driverId = url.substring(5, i - 1);
            }
            StringTokenizer st = new StringTokenizer(url, ";");
            while (st.hasMoreTokens()) {
                String tokenValue;
                String tokenPairStr = st.nextToken().trim();
                String[] tokenPair = tokenPairStr.split("=", 2);
                String token = tokenPair[0];
                String string = tokenValue = tokenPair.length == 2 ? tokenPair[1].trim() : null;
                if (tokenPairStr.startsWith("jdbc")) {
                    this.realUrl = tokenPairStr.replaceFirst(SIMON_JDBC, "jdbc");
                    continue;
                }
                if (token.equalsIgnoreCase(Driver.REAL_DRIVER)) {
                    this.realDriver = tokenValue;
                    continue;
                }
                if (token.equalsIgnoreCase(Driver.PREFIX)) {
                    this.prefix = tokenValue;
                    continue;
                }
                this.realUrl = this.realUrl + ";" + tokenPairStr;
            }
        }

        public String getRealUrl() {
            return this.realUrl;
        }

        public String getDriverId() {
            return this.driverId;
        }

        public String getRealDriver() {
            return this.realDriver;
        }

        public String getPrefix() {
            return this.prefix == null ? Driver.DEFAULT_PREFIX : this.prefix;
        }
    }
}

