/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.action;

import java.io.IOException;
import javax.servlet.ServletException;
import org.javasimon.Simon;
import org.javasimon.console.Action;
import org.javasimon.console.ActionContext;
import org.javasimon.console.ActionException;
import org.javasimon.console.SimonType;
import org.javasimon.console.SimonTypeFactory;
import org.javasimon.console.TimeFormatType;
import org.javasimon.console.action.DetailHtmlBuilder;
import org.javasimon.console.action.DetailPlugin;
import org.javasimon.console.text.StringifierFactory;

public class DetailHtmlAction
extends Action {
    public static final String PATH = "/data/detail.html";
    protected StringifierFactory stringifierFactory = new StringifierFactory();
    private String name;

    public DetailHtmlAction(ActionContext context) {
        super(context);
    }

    public void readParameters() {
        this.name = this.getContext().getParameterAsString("name", null);
        this.stringifierFactory.init(this.getContext().getParameterAsEnum("timeFormat", TimeFormatType.class, TimeFormatType.MILLISECOND), "yyyy-MM-dd HH:mm:ss", "0.000");
    }

    public void execute() throws ServletException, IOException, ActionException {
        if (this.name == null) {
            throw new ActionException("Null name");
        }
        Simon simon = this.getContext().getManager().getSimon(this.name);
        if (simon == null) {
            throw new ActionException("Simon \"" + this.name + "\" not found");
        }
        this.getContext().setContentType("text/html");
        SimonType simonType = SimonTypeFactory.getValueFromInstance(simon);
        DetailHtmlBuilder htmlBuilder = new DetailHtmlBuilder(this.getContext().getWriter(), this.stringifierFactory);
        ((DetailHtmlBuilder)((DetailHtmlBuilder)((DetailHtmlBuilder)htmlBuilder.header("Detail View", DetailPlugin.getResources(this.getContext(), DetailPlugin.class))).beginSection("simonPanel", "Simon").beginRow().simonProperty(simon, "Name", "name", 5).endRow().beginRow().labelCell("Type").beginValueCell().simonTypeImg(simonType, "../../")).object((Object)simonType)).endValueCell().simonProperty(simon, "State", "state").simonProperty(simon, "Enabled", "enabled").endRow().beginRow().simonProperty(simon, "Note", "note", 5).endRow().beginRow().simonProperty(simon, "First Use", "firstUsage").simonProperty(simon, "Last Reset", "lastReset").simonProperty(simon, "Last Use", "lastUsage").endRow().endSection();
        switch (simonType) {
            case STOPWATCH: {
                htmlBuilder.beginSection("stopwatchPanel", "Stopwatch").beginRow().simonProperty(simon, "Counter", "counter").simonProperty(simon, "Total", "total", 3).endRow().beginRow().simonProperty(simon, "Min", "min", 3).simonProperty(simon, "Min Timestamp", "minTimeStamp").endRow().beginRow().simonProperty(simon, "Mean", "mean").simonProperty(simon, "Standard Deviation", "standardDeviation", 3).endRow().beginRow().simonProperty(simon, "Max", "max", 3).simonProperty(simon, "Max Timestamp", "maxTimeStamp").endRow().beginRow().simonProperty(simon, "Last", "last", 3).simonProperty(simon, "Last Timestamp", "lastUsage").endRow().beginRow().simonProperty(simon, "Active", "active").simonProperty(simon, "Max Active", "maxActive").simonProperty(simon, "Max Active Timestamp", "maxActiveTimestamp").endRow().endSection();
                break;
            }
            case COUNTER: {
                htmlBuilder.beginSection("counterPanel", "Counter").beginRow().simonProperty(simon, "Counter", "counter").endRow().beginRow().simonProperty(simon, "Min", "min").simonProperty(simon, "Min Timestamp", "minTimeStamp").endRow().beginRow().simonProperty(simon, "Max", "max").simonProperty(simon, "Max Timestamp", "maxTimeStamp").endRow().beginRow().simonProperty(simon, "Increment Sum", "incrementSum").simonProperty(simon, "Decrement Sum", "decrementSum").endRow().endSection();
            }
        }
        for (DetailPlugin plugin : this.getContext().getPluginManager().getPluginsByType(DetailPlugin.class)) {
            if (!plugin.supports(simon)) continue;
            htmlBuilder.beginSection(plugin.getId() + "Panel", plugin.getLabel());
            plugin.executeHtml(this.getContext(), htmlBuilder, this.stringifierFactory, simon);
            htmlBuilder.endSection();
        }
        htmlBuilder.footer();
    }
}

