/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.action;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.javasimon.Sample;
import org.javasimon.Simon;
import org.javasimon.SimonState;
import org.javasimon.console.Action;
import org.javasimon.console.ActionContext;
import org.javasimon.console.ActionException;
import org.javasimon.console.SimonType;
import org.javasimon.console.SimonTypeFactory;
import org.javasimon.console.TimeFormatType;
import org.javasimon.console.json.JsonStringifierFactory;
import org.javasimon.console.json.ObjectJS;
import org.javasimon.console.json.SimpleJS;
import org.javasimon.console.text.Stringifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJsonAction
extends Action {
    protected final JsonStringifierFactory jsonStringifierFactory = new JsonStringifierFactory();
    protected boolean reset;

    protected AbstractJsonAction(ActionContext context) {
        super(context);
    }

    @Override
    public void readParameters() {
        TimeFormatType timeFormat = this.getContext().getParameterAsEnum("timeFormat", TimeFormatType.class, TimeFormatType.MILLISECOND);
        this.jsonStringifierFactory.init(timeFormat, "yyyy-MM-dd HH:mm:ss", "0");
        this.reset = this.getContext().getParameterAsBoolean("reset", Boolean.FALSE);
    }

    private <T> void addAttribute(ObjectJS objectJS, String name, Class<T> type, T value) {
        objectJS.setAttribute(name, new SimpleJS<T>(value, this.jsonStringifierFactory.getStringifier(type)));
    }

    protected ObjectJS createObjectJS(Simon simon) {
        Sample sample = this.reset ? simon.sampleAndReset() : simon.sample();
        SimonType lType = SimonTypeFactory.getValueFromInstance(sample);
        ObjectJS objectJS = ObjectJS.create(sample, this.jsonStringifierFactory);
        this.addAttribute(objectJS, "type", SimonType.class, lType);
        this.addAttribute(objectJS, "enabled", Boolean.class, simon.isEnabled());
        this.addAttribute(objectJS, "state", SimonState.class, simon.getState());
        return objectJS;
    }

    protected final ObjectJS createAttributesObjectJS(Simon simon) {
        ObjectJS objectJS = new ObjectJS();
        Iterator attributeNameIter = simon.getAttributeNames();
        boolean foundAttribute = false;
        while (attributeNameIter.hasNext()) {
            Stringifier<?> attributeStringifier;
            String attributeName = (String)attributeNameIter.next();
            Object attributeValue = simon.getAttribute(attributeName);
            if (attributeValue == null || (attributeStringifier = this.jsonStringifierFactory.getStringifier(attributeValue.getClass())) == null) continue;
            objectJS.setSimpleAttribute(attributeName, attributeValue, attributeStringifier);
            foundAttribute = true;
        }
        return foundAttribute ? objectJS : null;
    }

    @Override
    public void execute() throws ServletException, IOException, ActionException {
        this.dontCache();
        this.getContext().setContentType("application/json");
    }
}

