/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.binary.geoshape;

import java.util.List;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.GeoshapeTypeSerializer;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.PointCollectionSerializer;
import org.locationtech.spatial4j.shape.ShapeFactory;

public class MultiPointSerializer
extends GeoshapeTypeSerializer {
    private static final PointCollectionSerializer pointCollectionSerializer = new PointCollectionSerializer();

    public MultiPointSerializer() {
        super(5);
    }

    @Override
    public Geoshape readNonNullableGeoshapeValue(Buffer buffer, GraphBinaryReader context) {
        List<double[]> points = pointCollectionSerializer.readPoints(buffer);
        ShapeFactory.MultiPointBuilder multiPointBuilder = Geoshape.getShapeFactory().multiPoint();
        for (double[] xy : points) {
            multiPointBuilder.pointXY(xy[0], xy[1]);
        }
        return Geoshape.geoshape(multiPointBuilder.build());
    }

    @Override
    public void writeNonNullableGeoshapeValue(Geoshape geoshape, Buffer buffer, GraphBinaryWriter context) {
        pointCollectionSerializer.writePointCollectionGeoshape(geoshape, buffer);
    }
}

