/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.attribute;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.tinkerpop.io.JanusGraphP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Text implements JanusGraphPredicate
{
    CONTAINS{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String terms) {
            HashSet<String> tokens = new HashSet<String>(1.tokenize(value.toLowerCase()));
            terms = terms.trim();
            List<String> tokenTerms = 1.tokenize(terms.toLowerCase());
            if (!terms.isEmpty() && tokenTerms.isEmpty()) {
                return false;
            }
            for (String term : tokenTerms) {
                if (tokens.contains(term)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String && StringUtils.isNotBlank((CharSequence)((String)condition));
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return NOT_CONTAINS;
        }

        public String toString() {
            return "textContains";
        }
    }
    ,
    NOT_CONTAINS{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String terms) {
            return !CONTAINS.evaluateRaw(value, terms);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return CONTAINS.isValidCondition(condition);
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return CONTAINS;
        }

        public String toString() {
            return "textNotContains";
        }
    }
    ,
    CONTAINS_PREFIX{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String prefix) {
            for (String token : 3.tokenize(value.toLowerCase())) {
                if (!PREFIX.evaluateRaw(token, prefix.toLowerCase())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String;
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return NOT_CONTAINS_PREFIX;
        }

        public String toString() {
            return "textContainsPrefix";
        }
    }
    ,
    NOT_CONTAINS_PREFIX{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String prefix) {
            return !CONTAINS_PREFIX.evaluateRaw(value, prefix);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return CONTAINS_PREFIX.isValidCondition(condition);
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return CONTAINS_PREFIX;
        }

        public String toString() {
            return "textNotContainsPrefix";
        }
    }
    ,
    CONTAINS_REGEX{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String regex) {
            for (String token : 5.tokenize(value.toLowerCase())) {
                if (!REGEX.evaluateRaw(token, regex)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String && StringUtils.isNotBlank((CharSequence)condition.toString());
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return NOT_CONTAINS_REGEX;
        }

        public String toString() {
            return "textContainsRegex";
        }
    }
    ,
    NOT_CONTAINS_REGEX{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String regex) {
            return !CONTAINS_REGEX.evaluateRaw(value, regex);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return CONTAINS_REGEX.isValidCondition(condition);
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return CONTAINS_REGEX;
        }

        public String toString() {
            return "textNotContainsRegex";
        }
    }
    ,
    PREFIX{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String prefix) {
            return value.startsWith(prefix.trim());
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String;
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return NOT_PREFIX;
        }

        public String toString() {
            return "textPrefix";
        }
    }
    ,
    NOT_PREFIX{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String prefix) {
            return !value.startsWith(prefix.trim());
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return PREFIX.isValidCondition(condition);
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return PREFIX;
        }

        public String toString() {
            return "textNotPrefix";
        }
    }
    ,
    REGEX{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String regex) {
            return value.matches(regex);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String && StringUtils.isNotBlank((CharSequence)condition.toString());
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return NOT_REGEX;
        }

        public String toString() {
            return "textRegex";
        }
    }
    ,
    NOT_REGEX{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String regex) {
            return !value.matches(regex);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return REGEX.isValidCondition(condition);
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return REGEX;
        }

        public String toString() {
            return "textNotRegex";
        }
    }
    ,
    FUZZY{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String term) {
            return Text.isFuzzy(term.trim(), value.trim());
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String && StringUtils.isNotBlank((CharSequence)condition.toString());
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return NOT_FUZZY;
        }

        public String toString() {
            return "textFuzzy";
        }
    }
    ,
    NOT_FUZZY{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String term) {
            return !Text.isFuzzy(term.trim(), value.trim());
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return FUZZY.isValidCondition(condition);
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return FUZZY;
        }

        public String toString() {
            return "textNotFuzzy";
        }
    }
    ,
    CONTAINS_FUZZY{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String term) {
            for (String token : 13.tokenize(value.toLowerCase())) {
                if (!Text.isFuzzy(term.toLowerCase(), token)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String && StringUtils.isNotBlank((CharSequence)condition.toString());
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return NOT_CONTAINS_FUZZY;
        }

        public String toString() {
            return "textContainsFuzzy";
        }
    }
    ,
    NOT_CONTAINS_FUZZY{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String term) {
            return !CONTAINS_FUZZY.evaluateRaw(value, term);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return CONTAINS_FUZZY.isValidCondition(condition);
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return CONTAINS_FUZZY;
        }

        public String toString() {
            return "textNotContainsFuzzy";
        }
    }
    ,
    CONTAINS_PHRASE{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String terms) {
            List<String> valueTerms = 15.tokenize(value.trim().toLowerCase());
            List<String> tokenTerms = 15.tokenize(terms.trim().toLowerCase());
            if (!terms.isEmpty() && tokenTerms.isEmpty()) {
                return false;
            }
            return Collections.indexOfSubList(valueTerms, tokenTerms) != -1;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String && StringUtils.isNotBlank((CharSequence)((String)condition));
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return NOT_CONTAINS_PHRASE;
        }

        public String toString() {
            return "textContainsPhrase";
        }
    }
    ,
    NOT_CONTAINS_PHRASE{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String terms) {
            return !CONTAINS_PHRASE.evaluateRaw(value, terms);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return CONTAINS_PHRASE.isValidCondition(condition);
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return CONTAINS_PHRASE;
        }

        public String toString() {
            return "textNotContainsPhrase";
        }
    };

    private static final LevenshteinDistance ONE_LEVENSHTEIN_DISTANCE;
    private static final LevenshteinDistance TWO_LEVENSHTEIN_DISTANCE;
    private static final Logger log;
    private static final int MIN_TOKEN_LENGTH = 1;
    public static final Set<Text> HAS_CONTAINS;

    public static int getMaxEditDistance(String term) {
        if (term.length() < 3) {
            return 0;
        }
        if (term.length() < 6) {
            return 1;
        }
        return 2;
    }

    private static boolean isFuzzy(String term, String value) {
        if ((term = term.trim()).length() < 3) {
            return term.equals(value);
        }
        if (term.length() < 6) {
            int levenshteinDistance = ONE_LEVENSHTEIN_DISTANCE.apply((CharSequence)value, (CharSequence)term);
            return levenshteinDistance <= 1 && levenshteinDistance >= 0;
        }
        int levenshteinDist = TWO_LEVENSHTEIN_DISTANCE.apply((CharSequence)value, (CharSequence)term);
        return levenshteinDist <= 2 && levenshteinDist >= 0;
    }

    public void preevaluate(Object value, Object condition) {
        Preconditions.checkArgument((boolean)this.isValidCondition(condition), (String)"Invalid condition provided: %s", (Object)condition);
        if (!(value instanceof String)) {
            log.debug("Value not a string: " + value);
        }
    }

    abstract boolean evaluateRaw(String var1, String var2);

    public static List<String> tokenize(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        int previous = 0;
        for (int p = 0; p < str.length(); ++p) {
            if (Character.isLetterOrDigit(str.charAt(p))) continue;
            if (p > previous + 1) {
                tokens.add(str.substring(previous, p));
            }
            previous = p + 1;
        }
        if (previous + 1 < str.length()) {
            tokens.add(str.substring(previous));
        }
        return tokens;
    }

    @Override
    public boolean isValidValueType(Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        return clazz.equals(String.class);
    }

    @Override
    public boolean hasNegation() {
        return false;
    }

    @Override
    public JanusGraphPredicate negate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isQNF() {
        return true;
    }

    public static <V> JanusGraphP textContains(V value) {
        return new JanusGraphP(CONTAINS, value);
    }

    public static <V> JanusGraphP textNotContains(V value) {
        return new JanusGraphP(NOT_CONTAINS, value);
    }

    public static <V> JanusGraphP textContainsPrefix(V value) {
        return new JanusGraphP(CONTAINS_PREFIX, value);
    }

    public static <V> JanusGraphP textNotContainsPrefix(V value) {
        return new JanusGraphP(NOT_CONTAINS_PREFIX, value);
    }

    public static <V> JanusGraphP textContainsRegex(V value) {
        return new JanusGraphP(CONTAINS_REGEX, value);
    }

    public static <V> JanusGraphP textNotContainsRegex(V value) {
        return new JanusGraphP(NOT_CONTAINS_REGEX, value);
    }

    public static <V> JanusGraphP textPrefix(V value) {
        return new JanusGraphP(PREFIX, value);
    }

    public static <V> JanusGraphP textNotPrefix(V value) {
        return new JanusGraphP(NOT_PREFIX, value);
    }

    public static <V> JanusGraphP textRegex(V value) {
        return new JanusGraphP(REGEX, value);
    }

    public static <V> JanusGraphP textNotRegex(V value) {
        return new JanusGraphP(NOT_REGEX, value);
    }

    public static <V> JanusGraphP textContainsFuzzy(V value) {
        return new JanusGraphP(CONTAINS_FUZZY, value);
    }

    public static <V> JanusGraphP textNotContainsFuzzy(V value) {
        return new JanusGraphP(NOT_CONTAINS_FUZZY, value);
    }

    public static <V> JanusGraphP textFuzzy(V value) {
        return new JanusGraphP(FUZZY, value);
    }

    public static <V> JanusGraphP textNotFuzzy(V value) {
        return new JanusGraphP(NOT_FUZZY, value);
    }

    public static <V> JanusGraphP textContainsPhrase(V value) {
        return new JanusGraphP(CONTAINS_PHRASE, value);
    }

    public static <V> JanusGraphP textNotContainsPhrase(V value) {
        return new JanusGraphP(NOT_CONTAINS_PHRASE, value);
    }

    static {
        ONE_LEVENSHTEIN_DISTANCE = new LevenshteinDistance(Integer.valueOf(1));
        TWO_LEVENSHTEIN_DISTANCE = new LevenshteinDistance(Integer.valueOf(2));
        log = LoggerFactory.getLogger(Text.class);
        HAS_CONTAINS = Collections.unmodifiableSet(EnumSet.of(CONTAINS, new Text[]{CONTAINS_PREFIX, CONTAINS_REGEX, CONTAINS_FUZZY, CONTAINS_PHRASE, NOT_CONTAINS, NOT_CONTAINS_PREFIX, NOT_CONTAINS_REGEX, NOT_CONTAINS_FUZZY, NOT_CONTAINS_PHRASE}));
    }
}

