/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.janusgraph.diskstorage.keycolumnvalue.KeysQueriesGroup;
import org.janusgraph.diskstorage.keycolumnvalue.MultiKeysQueryGroups;
import org.janusgraph.diskstorage.keycolumnvalue.MultiQueriesByKeysGroupsContext;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.query.BackendQueryHolder;
import org.janusgraph.graphdb.vertices.CacheVertex;

public class MultiSliceQueriesGroupingUtil {
    private static final MultiKeysQueryGroups<Object, SliceQuery> EMPTY_QUERY = new MultiKeysQueryGroups(Collections.emptyList(), new MultiQueriesByKeysGroupsContext<Object>(new Object[0], new TreeNode(), 0, Collections.emptyList()));

    public static <K> void moveQueriesToNewLeafNode(List<Pair<SliceQuery, List<K>>> updatedQueryGroup, K[] allVertices, TreeNode groupingRootTreeNode, List<KeysQueriesGroup<K, SliceQuery>> remainingQueryGroups) {
        for (Pair<SliceQuery, List<K>> keyNewQueriesGroup : updatedQueryGroup) {
            DataTreeNode chainLeafNode;
            boolean newChainGenerated = false;
            TreeNode previousNode = groupingRootTreeNode;
            TreeNode currentNode = groupingRootTreeNode;
            boolean rightNode = false;
            Iterator usedKeyIt = ((List)keyNewQueriesGroup.getValue()).iterator();
            for (int keyIndex = 0; keyIndex < allVertices.length; ++keyIndex) {
                Object usedKey;
                Object v0 = usedKey = usedKeyIt.hasNext() ? usedKeyIt.next() : null;
                while (keyIndex < allVertices.length && usedKey != allVertices[keyIndex]) {
                    rightNode = false;
                    if (currentNode.left == null) {
                        currentNode.left = new TreeNode();
                        newChainGenerated = true;
                    }
                    previousNode = currentNode;
                    currentNode = currentNode.left;
                    ++keyIndex;
                }
                if (keyIndex == allVertices.length) break;
                rightNode = true;
                if (currentNode.right == null) {
                    currentNode.right = new TreeNode();
                    newChainGenerated = true;
                }
                previousNode = currentNode;
                currentNode = currentNode.right;
            }
            if (newChainGenerated) {
                KeysQueriesGroup data = new KeysQueriesGroup((List)keyNewQueriesGroup.getValue(), new ArrayList());
                chainLeafNode = new DataTreeNode(data);
                if (rightNode) {
                    previousNode.right = chainLeafNode;
                } else {
                    previousNode.left = chainLeafNode;
                }
                remainingQueryGroups.add(data);
            } else {
                chainLeafNode = (DataTreeNode)currentNode;
            }
            ((KeysQueriesGroup)chainLeafNode.data).getQueries().add(keyNewQueriesGroup.getKey());
        }
    }

    public static <C, N> void replaceCurrentLeafNodeWithUpdatedTypeLeafNodes(List<TreeNode> allLeafParents, Map<C, N> oldToNewKeysMap) {
        for (TreeNode node : allLeafParents) {
            if (node.left instanceof DataTreeNode) {
                node.left = MultiSliceQueriesGroupingUtil.generateConvertedLeafNode((DataTreeNode)node.left, oldToNewKeysMap);
            }
            if (!(node.right instanceof DataTreeNode)) continue;
            node.right = MultiSliceQueriesGroupingUtil.generateConvertedLeafNode((DataTreeNode)node.right, oldToNewKeysMap);
        }
    }

    private static <C, N> DataTreeNode<KeysQueriesGroup<N, SliceQuery>> generateConvertedLeafNode(DataTreeNode<KeysQueriesGroup<C, SliceQuery>> currentLeafNode, Map<C, N> oldToNewKeysMap) {
        KeysQueriesGroup data = (KeysQueriesGroup)currentLeafNode.data;
        ArrayList<N> keysGroup = new ArrayList<N>(data.getKeysGroup().size());
        for (Object currentKey : data.getKeysGroup()) {
            keysGroup.add(oldToNewKeysMap.get(currentKey));
        }
        KeysQueriesGroup newData = new KeysQueriesGroup(keysGroup, data.getQueries());
        return new DataTreeNode<KeysQueriesGroup<N, SliceQuery>>(newData);
    }

    public static MultiKeysQueryGroups<Object, SliceQuery> toMultiKeysQueryGroups(Collection<InternalVertex> vertices, List<BackendQueryHolder<SliceQuery>> queries) {
        if (queries.isEmpty()) {
            return EMPTY_QUERY;
        }
        MutableInt verticesMutableSize = new MutableInt();
        InternalVertex[] cacheableVertices = MultiSliceQueriesGroupingUtil.filterNonCacheableVertices(vertices, verticesMutableSize);
        int verticesSize = verticesMutableSize.intValue();
        Object[] vertexIds = MultiSliceQueriesGroupingUtil.toIds(cacheableVertices, verticesSize);
        if (verticesSize == 0) {
            return EMPTY_QUERY;
        }
        ArrayList<KeysQueriesGroup<Object, SliceQuery>> result = new ArrayList<KeysQueriesGroup<Object, SliceQuery>>();
        TreeNode root = new TreeNode();
        boolean[] useVertex = new boolean[verticesSize];
        ArrayList<TreeNode> allLeafParents = new ArrayList<TreeNode>();
        for (BackendQueryHolder<SliceQuery> queryHolder : queries) {
            SliceQuery query = queryHolder.getBackendQuery();
            TreeNode currentNode = root;
            int usedVertices = 0;
            for (int i = 0; i < verticesSize; ++i) {
                if (cacheableVertices[i].hasLoadedRelations(query)) {
                    useVertex[i] = false;
                    if (currentNode.left == null) {
                        currentNode = MultiSliceQueriesGroupingUtil.generateNewChainAndReturnLeafNode(true, currentNode, cacheableVertices, useVertex, i, usedVertices, verticesSize, query, result, allLeafParents);
                        break;
                    }
                    currentNode = currentNode.left;
                    continue;
                }
                useVertex[i] = true;
                ++usedVertices;
                if (currentNode.right == null) {
                    currentNode = MultiSliceQueriesGroupingUtil.generateNewChainAndReturnLeafNode(false, currentNode, cacheableVertices, useVertex, i, usedVertices, verticesSize, query, result, allLeafParents);
                    break;
                }
                currentNode = currentNode.right;
            }
            ((KeysQueriesGroup)((DataTreeNode)currentNode).data).getQueries().add(query);
        }
        return new MultiKeysQueryGroups<Object, SliceQuery>(result, new MultiQueriesByKeysGroupsContext<Object>(vertexIds, root, queries.size(), allLeafParents));
    }

    private static InternalVertex[] filterNonCacheableVertices(Collection<InternalVertex> vertices, MutableInt verticesMutableSize) {
        InternalVertex[] cacheableVertices = new InternalVertex[vertices.size()];
        int i = 0;
        for (InternalVertex v : vertices) {
            if (v.isNew() || !v.hasId() || !(v instanceof CacheVertex)) continue;
            cacheableVertices[i++] = v;
        }
        verticesMutableSize.setValue(i);
        return cacheableVertices;
    }

    private static Object[] toPartiallyFilledVertexIds(InternalVertex[] cacheableVertices, boolean[] useVertex, int fillUpToIndex, int totalVerticesSize) {
        Object[] vertexIds = new Object[totalVerticesSize];
        int j = 0;
        for (int i = 0; i <= fillUpToIndex; ++i) {
            if (!useVertex[i]) continue;
            vertexIds[j++] = cacheableVertices[i].id();
        }
        return vertexIds;
    }

    private static Object[] toIds(InternalVertex[] cacheableVertices, int totalVerticesSize) {
        Object[] vertexIds = new Object[totalVerticesSize];
        for (int i = 0; i < totalVerticesSize; ++i) {
            vertexIds[i] = cacheableVertices[i].id();
        }
        return vertexIds;
    }

    private static TreeNode generateNewChainAndReturnLeafNode(boolean childNodeHasLoadedRelations, TreeNode currentNode, InternalVertex[] cacheableVertices, boolean[] useVertex, int currentIndex, int usedVertices, int totalVerticesSize, SliceQuery query, List<KeysQueriesGroup<Object, SliceQuery>> result, List<TreeNode> allLeafParents) {
        DataTreeNode previousNode = currentNode;
        currentNode = new TreeNode();
        MultiSliceQueriesGroupingUtil.assignChild(previousNode, currentNode, childNodeHasLoadedRelations);
        Object[] queryVertexIds = MultiSliceQueriesGroupingUtil.toPartiallyFilledVertexIds(cacheableVertices, useVertex, currentIndex, totalVerticesSize);
        ChainCreationResult newChain = MultiSliceQueriesGroupingUtil.generateNewNodesChain(cacheableVertices, queryVertexIds, previousNode, currentNode, currentIndex, usedVertices, totalVerticesSize, childNodeHasLoadedRelations, query);
        previousNode = newChain.latestParent;
        usedVertices = newChain.usedVerticesCount;
        if (usedVertices != totalVerticesSize) {
            if (usedVertices == 0) {
                queryVertexIds = new Object[]{};
            } else {
                Object[] trimmedQueryVertexIds = new Object[usedVertices];
                System.arraycopy(queryVertexIds, 0, trimmedQueryVertexIds, 0, usedVertices);
                queryVertexIds = trimmedQueryVertexIds;
            }
        }
        KeysQueriesGroup data = new KeysQueriesGroup(Arrays.asList(queryVertexIds), new ArrayList());
        currentNode = new DataTreeNode(data);
        MultiSliceQueriesGroupingUtil.assignChild(previousNode, currentNode, newChain.lastVertexHasLoadedRelations);
        if (previousNode.left == null || previousNode.right == null) {
            allLeafParents.add(previousNode);
        }
        if (usedVertices > 0) {
            result.add(data);
        }
        return currentNode;
    }

    private static void assignChild(TreeNode parent, TreeNode child, boolean childNodeHasLoadedRelations) {
        if (childNodeHasLoadedRelations) {
            parent.left = child;
        } else {
            parent.right = child;
        }
    }

    private static ChainCreationResult generateNewNodesChain(InternalVertex[] cacheableVertices, Object[] queryVertexIds, TreeNode previousNode, TreeNode currentNode, int currentIndex, int usedVertices, int totalVerticesSize, boolean lastChildHasLoadedRelations, SliceQuery currentQuery) {
        boolean hasLoadedRelations = lastChildHasLoadedRelations;
        while (++currentIndex < totalVerticesSize) {
            previousNode = currentNode;
            hasLoadedRelations = cacheableVertices[currentIndex].hasLoadedRelations(currentQuery);
            if (hasLoadedRelations) {
                currentNode = currentNode.left = new TreeNode();
                continue;
            }
            currentNode = currentNode.right = new TreeNode();
            queryVertexIds[usedVertices++] = cacheableVertices[currentIndex].id();
        }
        return new ChainCreationResult(previousNode, hasLoadedRelations, usedVertices);
    }

    private static class ChainCreationResult {
        public final TreeNode latestParent;
        public final boolean lastVertexHasLoadedRelations;
        public final int usedVerticesCount;

        private ChainCreationResult(TreeNode latestParent, boolean lastVertexHasLoadedRelations, int usedVerticesCount) {
            this.latestParent = latestParent;
            this.lastVertexHasLoadedRelations = lastVertexHasLoadedRelations;
            this.usedVerticesCount = usedVerticesCount;
        }
    }

    public static class DataTreeNode<Q>
    extends TreeNode {
        public final Q data;

        public DataTreeNode(Q data) {
            this.data = data;
        }
    }

    public static class TreeNode {
        public TreeNode left;
        public TreeNode right;

        public TreeNode() {
        }

        public TreeNode(TreeNode left, TreeNode right) {
            this.left = left;
            this.right = right;
        }
    }
}

