/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types.system;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.JanusGraphSchemaType;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.IndexField;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.TypeDefinitionDescription;
import org.janusgraph.graphdb.types.indextype.IndexReferenceType;
import org.janusgraph.graphdb.types.system.BaseRelationType;

public class BaseKey
extends BaseRelationType
implements PropertyKey {
    public static final BaseKey VertexExists = new BaseKey("VertexExists", Boolean.class, 1, Index.NONE, Cardinality.SINGLE);
    public static final BaseKey SchemaName = new BaseKey("SchemaName", String.class, 32, Index.UNIQUE, Cardinality.SINGLE);
    public static final BaseKey SchemaDefinitionProperty = new BaseKey("SchemaDefinitionProperty", Object.class, 33, Index.NONE, Cardinality.LIST);
    public static final BaseKey SchemaCategory = new BaseKey("SchemaCategory", JanusGraphSchemaCategory.class, 34, Index.STANDARD, Cardinality.SINGLE);
    public static final BaseKey SchemaDefinitionDesc = new BaseKey("SchemaDefinitionDescription", TypeDefinitionDescription.class, 35, Index.NONE, Cardinality.SINGLE);
    public static final BaseKey SchemaUpdateTime = new BaseKey("SchemaUpdateTimestamp", Long.class, 36, Index.NONE, Cardinality.SINGLE);
    private final Class<?> dataType;
    private final Index index;
    private final Cardinality cardinality;
    private final CompositeIndexType indexDef = new CompositeIndexType(){
        private final IndexField[] fields;
        {
            this.fields = new IndexField[]{IndexField.of(BaseKey.this)};
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public long longId() {
            return BaseKey.this.longId();
        }

        @Override
        public long getID() {
            return ((Number)this.id()).longValue();
        }

        @Override
        public IndexField[] getFieldKeys() {
            return this.fields;
        }

        @Override
        public String[] getInlineFieldKeys() {
            return CompositeIndexType.EMPTY_INLINE_PROPS;
        }

        @Override
        public IndexField getField(PropertyKey key) {
            if (key.equals(BaseKey.this)) {
                return this.fields[0];
            }
            return null;
        }

        @Override
        public boolean indexesKey(PropertyKey key) {
            return this.getField(key) != null;
        }

        @Override
        public Cardinality getCardinality() {
            switch (BaseKey.this.index) {
                case UNIQUE: {
                    return Cardinality.SINGLE;
                }
                case STANDARD: {
                    return Cardinality.LIST;
                }
            }
            throw new AssertionError();
        }

        @Override
        public ConsistencyModifier getConsistencyModifier() {
            return ConsistencyModifier.LOCK;
        }

        @Override
        public ElementCategory getElement() {
            return ElementCategory.VERTEX;
        }

        @Override
        public boolean hasSchemaTypeConstraint() {
            return false;
        }

        @Override
        public JanusGraphSchemaType getSchemaTypeConstraint() {
            return null;
        }

        @Override
        public boolean isCompositeIndex() {
            return true;
        }

        @Override
        public boolean isMixedIndex() {
            return false;
        }

        @Override
        public String getBackingIndexName() {
            return "internalindex";
        }

        @Override
        public String getName() {
            return "SystemIndex#" + BaseKey.this.name();
        }

        @Override
        public SchemaStatus getStatus() {
            return SchemaStatus.ENABLED;
        }

        @Override
        public void resetCache() {
        }
    };

    private BaseKey(String name, Class<?> dataType, int id, Index index, Cardinality cardinality) {
        super(name, id, JanusGraphSchemaCategory.PROPERTYKEY);
        Preconditions.checkArgument((index != null && cardinality != null ? 1 : 0) != 0);
        this.dataType = dataType;
        this.index = index;
        this.cardinality = cardinality;
    }

    @Override
    public Class<?> dataType() {
        return this.dataType;
    }

    @Override
    public final boolean isPropertyKey() {
        return true;
    }

    @Override
    public final boolean isEdgeLabel() {
        return false;
    }

    @Override
    public Multiplicity multiplicity() {
        return Multiplicity.convert(this.cardinality());
    }

    @Override
    public boolean isUnidirected(Direction dir) {
        return dir == Direction.OUT;
    }

    @Override
    public Cardinality cardinality() {
        return this.cardinality;
    }

    @Override
    public Iterable<IndexType> getKeyIndexes() {
        if (this.index == Index.NONE) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(this.indexDef);
    }

    @Override
    public Iterable<IndexReferenceType> getKeyIndexesReferences() {
        return Iterables.transform(this.getKeyIndexes(), indexType -> new IndexReferenceType(false, (IndexType)indexType));
    }

    private static enum Index {
        NONE,
        STANDARD,
        UNIQUE;

    }
}

