/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types.indextype;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.IndexField;
import org.janusgraph.graphdb.types.ParameterType;
import org.janusgraph.graphdb.types.SchemaSource;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeUtil;
import org.janusgraph.graphdb.types.indextype.IndexTypeWrapper;

public class CompositeIndexTypeWrapper
extends IndexTypeWrapper
implements CompositeIndexType {
    private IndexField[] fields = null;
    private String[] inlineKeys = null;
    private ConsistencyModifier consistency = null;

    public CompositeIndexTypeWrapper(SchemaSource base) {
        super(base);
    }

    @Override
    public boolean isCompositeIndex() {
        return true;
    }

    @Override
    public boolean isMixedIndex() {
        return false;
    }

    @Override
    public long getID() {
        return this.base.longId();
    }

    @Override
    public SchemaStatus getStatus() {
        return this.base.getStatus();
    }

    @Override
    public IndexField[] getFieldKeys() {
        IndexField[] result = this.fields;
        if (result == null) {
            List<SchemaSource.Entry> entries = this.base.getRelated(TypeDefinitionCategory.INDEX_FIELD, Direction.OUT);
            int numFields = entries.size();
            result = new IndexField[numFields];
            for (SchemaSource.Entry entry : entries) {
                Integer value = ParameterType.INDEX_POSITION.findParameter((Parameter[])entry.getModifier(), null);
                Preconditions.checkNotNull((Object)value);
                int pos = value;
                Preconditions.checkArgument((pos >= 0 && pos < numFields ? 1 : 0) != 0, (String)"Invalid field position: %s", (int)pos);
                assert (entry.getSchemaType() instanceof PropertyKey);
                result[pos] = IndexField.of((PropertyKey)((Object)entry.getSchemaType()));
            }
            this.fields = result;
        }
        assert (result != null);
        return result;
    }

    @Override
    public String[] getInlineFieldKeys() {
        String[] result = this.inlineKeys;
        if (result == null) {
            List<SchemaSource.Entry> entries = this.base.getRelated(TypeDefinitionCategory.INDEX_INLINE_KEY, Direction.OUT);
            int numFields = entries.size();
            result = new String[numFields];
            int pos = 0;
            for (SchemaSource.Entry entry : entries) {
                assert (entry.getSchemaType() instanceof PropertyKey);
                result[pos] = ((PropertyKey)((Object)entry.getSchemaType())).name();
                ++pos;
            }
            this.inlineKeys = result;
        }
        return result;
    }

    @Override
    public void resetCache() {
        super.resetCache();
        this.fields = null;
        this.inlineKeys = null;
    }

    @Override
    public Cardinality getCardinality() {
        return this.base.getDefinition().getValue(TypeDefinitionCategory.INDEX_CARDINALITY, Cardinality.class);
    }

    @Override
    public ConsistencyModifier getConsistencyModifier() {
        if (this.consistency == null) {
            this.consistency = TypeUtil.getConsistencyModifier(this.base);
        }
        return this.consistency;
    }
}

