/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.lock;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.graphdb.transaction.lock.TransactionLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReentrantTransactionLock
extends ReentrantLock
implements TransactionLock {
    private static final long serialVersionUID = -1533050153710486569L;
    private static final Logger log = LoggerFactory.getLogger(ReentrantTransactionLock.class);

    @Override
    public void lock(Duration timeout) {
        boolean success = false;
        try {
            success = super.tryLock(timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Interrupted waiting for lock: {}", (Object)this, (Object)e);
        }
        if (!success) {
            throw new JanusGraphException("Possible dead lock detected. Waited for transaction lock without success");
        }
    }

    @Override
    public boolean inUse() {
        return super.isLocked() || super.hasQueuedThreads();
    }
}

