/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.addedrelations;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.ObjectSet;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.relations.StandardRelation;
import org.janusgraph.graphdb.transaction.addedrelations.AddedPropertiesListValue;
import org.janusgraph.graphdb.transaction.addedrelations.AddedPropertiesSetValue;
import org.janusgraph.graphdb.transaction.addedrelations.AddedPropertiesSingleValue;
import org.janusgraph.graphdb.transaction.addedrelations.AddedPropertiesValue;
import org.janusgraph.graphdb.transaction.addedrelations.AddedRelationsContainer;

public class SimpleAddedRelations
implements AddedRelationsContainer {
    private static final int INITIAL_PROP_ADDED_SIZE = 30;
    private static final int INITIAL_EDGE_ADDED_SIZE = 300;
    private int propertiesSize = 0;
    private final Boolean groupPropertiesByKey;
    private final Map<String, AddedPropertiesValue> propertiesMap;
    private final ObjectSet<InternalRelation> propertiesContainer;
    private final ObjectSet<InternalRelation> edgesContainer;
    private final Map<Long, ObjectSet<InternalRelation>> previousRelContainer;

    public SimpleAddedRelations(Boolean groupPropertiesByKey) {
        this.groupPropertiesByKey = groupPropertiesByKey;
        this.propertiesContainer = new ObjectHashSet(groupPropertiesByKey != false ? 0 : 30);
        this.propertiesMap = new HashMap<String, AddedPropertiesValue>(groupPropertiesByKey != false ? 30 : 0);
        this.edgesContainer = new ObjectHashSet(300);
        this.previousRelContainer = new HashMap<Long, ObjectSet<InternalRelation>>(330);
    }

    @Override
    public boolean add(InternalRelation relation) {
        if (relation.isEdge()) {
            this.edgesContainer.add((Object)relation);
        } else if (relation.isProperty()) {
            if (this.groupPropertiesByKey.booleanValue()) {
                this.addProperty(relation);
            } else {
                this.propertiesContainer.add((Object)relation);
            }
        } else {
            throw new IllegalArgumentException("Unexpected relation type " + relation.getType().label());
        }
        this.addPreviousRelation(relation);
        return true;
    }

    private boolean addProperty(InternalRelation relation) {
        String key = relation.getType().name();
        Cardinality cardinality = ((PropertyKey)relation.getType()).cardinality();
        AddedPropertiesValue propertiesValue = this.propertiesMap.computeIfAbsent(key, k -> {
            if (Cardinality.SINGLE.equals((Object)cardinality)) {
                return new AddedPropertiesSingleValue();
            }
            if (Cardinality.SET.equals((Object)cardinality)) {
                return new AddedPropertiesSetValue();
            }
            return new AddedPropertiesListValue();
        });
        this.propertiesSize += propertiesValue.addValue(relation);
        return true;
    }

    @Override
    public boolean remove(InternalRelation relation) {
        if (relation.isEdge()) {
            this.edgesContainer.removeAll((Object)relation);
        } else if (relation.isProperty()) {
            if (this.groupPropertiesByKey.booleanValue()) {
                this.removeProperty(relation);
            } else {
                this.propertiesContainer.removeAll((Object)relation);
            }
        } else {
            throw new IllegalArgumentException("Unexpected relation type " + relation.getType().label());
        }
        this.removePreviousRelation(relation);
        return true;
    }

    private boolean removeProperty(InternalRelation relation) {
        String key = relation.getType().name();
        AddedPropertiesValue propertiesValue = this.propertiesMap.computeIfPresent(key, (k, v) -> {
            this.propertiesSize -= v.removeValue(relation);
            return v;
        });
        if (propertiesValue != null) {
            if (propertiesValue.isNull()) {
                this.propertiesMap.remove(key);
            }
            return true;
        }
        return false;
    }

    @Override
    public Iterable<InternalRelation> getView(Predicate<InternalRelation> filter) {
        return Iterables.filter(this::iterator, filter);
    }

    @Override
    public Iterable<InternalRelation> getViewOfProperties(Predicate<InternalRelation> filter) {
        return Iterables.filter(this.toIterable(() -> Iterators.concat(this.getAllProperties(), this.toIterator(this.propertiesContainer))), filter);
    }

    @Override
    public List<InternalRelation> getViewOfProperties(String ... keys) {
        Iterator<InternalRelation> iterator = keys.length == 0 ? this.getAllProperties() : this.getPropertiesForKeys(keys);
        ArrayList<InternalRelation> result = new ArrayList<InternalRelation>(this.propertiesSize);
        iterator.forEachRemaining(result::add);
        return result;
    }

    @Override
    public List<InternalRelation> getViewOfProperties(String key, Object value) {
        Iterator<InternalRelation> iterator = this.getPropertiesForKey(key, value);
        ArrayList<InternalRelation> result = new ArrayList<InternalRelation>(this.propertiesSize);
        iterator.forEachRemaining(result::add);
        return result;
    }

    @Override
    public Iterable<InternalRelation> getViewOfPreviousRelations(long id) {
        if (this.previousRelContainer.containsKey(id)) {
            return this.toIterable(this.previousRelContainer.get(id));
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isEmpty() {
        return this.edgesContainer.isEmpty() && this.propertiesContainer.isEmpty() && this.propertiesSize == 0;
    }

    @Override
    public Collection<InternalRelation> getAllUnsafe() {
        return Collections.unmodifiableCollection(new AbstractCollection<InternalRelation>(){

            @Override
            @Nonnull
            public Iterator<InternalRelation> iterator() {
                return SimpleAddedRelations.this.iterator();
            }

            @Override
            public int size() {
                return SimpleAddedRelations.this.propertiesSize + SimpleAddedRelations.this.propertiesContainer.size() + SimpleAddedRelations.this.edgesContainer.size();
            }
        });
    }

    @Override
    public void clear() {
        this.propertiesMap.values().forEach(AddedPropertiesValue::clear);
        this.propertiesMap.clear();
        this.propertiesSize = 0;
        this.propertiesContainer.release();
        this.edgesContainer.release();
        this.previousRelContainer.clear();
    }

    private void addPreviousRelation(InternalRelation relation) {
        long prevId;
        if (relation instanceof StandardRelation && (prevId = ((StandardRelation)relation).getPreviousID()) > 0L) {
            if (!this.previousRelContainer.containsKey(prevId)) {
                this.previousRelContainer.put(prevId, (ObjectSet<InternalRelation>)new ObjectHashSet(1));
            }
            this.previousRelContainer.get(prevId).add((Object)relation);
        }
    }

    private void removePreviousRelation(InternalRelation relation) {
        long prevId;
        if (relation instanceof StandardRelation && this.previousRelContainer.containsKey(prevId = ((StandardRelation)relation).getPreviousID())) {
            this.previousRelContainer.get(prevId).removeAll((Object)relation);
        }
    }

    private Iterator<InternalRelation> getAllProperties() {
        return Iterators.concat(this.propertiesMap.values().stream().map(AddedPropertiesValue::getView).iterator());
    }

    private Iterator<InternalRelation> getPropertiesForKeys(String ... keys) {
        return Iterators.concat(Stream.of(keys).filter(this.propertiesMap::containsKey).map(k -> this.propertiesMap.get(k).getView()).iterator());
    }

    private Iterator<InternalRelation> getPropertiesForKey(String key, Object value) {
        AddedPropertiesValue propValue = this.propertiesMap.get(key);
        if (propValue == null) {
            return Collections.emptyIterator();
        }
        return propValue.getView(value);
    }

    private Iterable<InternalRelation> toIterable(ObjectSet<InternalRelation> relationObjectSet) {
        return this.toIterable(() -> this.toIterator(relationObjectSet));
    }

    private Iterable<InternalRelation> toIterable(final Callable<Iterator<InternalRelation>> internalRelationIterator) {
        return new FluentIterable<InternalRelation>(){

            public Iterator<InternalRelation> iterator() {
                try {
                    return (Iterator)internalRelationIterator.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private Iterator<InternalRelation> iterator() {
        return Iterators.concat(this.getAllProperties(), this.toIterator(this.propertiesContainer), this.toIterator(this.edgesContainer));
    }

    private Iterator<InternalRelation> toIterator(ObjectSet<InternalRelation> relationObjectSet) {
        return Iterators.transform((Iterator)relationObjectSet.iterator(), e -> {
            assert (e != null);
            return (InternalRelation)e.value;
        });
    }
}

