/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap;

import com.google.common.base.Preconditions;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.graphdb.database.StandardJanusGraph;

public class GraphProvider {
    private StandardJanusGraph graph = null;
    private boolean provided = false;

    public void setGraph(JanusGraph graph) {
        Preconditions.checkArgument((graph != null && graph.isOpen() ? 1 : 0) != 0, (Object)"Need to provide open graph");
        this.graph = (StandardJanusGraph)graph;
        this.provided = true;
    }

    public void initializeGraph(Configuration config) {
        if (!this.provided) {
            this.graph = (StandardJanusGraph)JanusGraphFactory.open((BasicConfiguration)config);
        }
    }

    public void close() {
        if (!this.provided && null != this.graph && this.graph.isOpen()) {
            this.graph.close();
            this.graph = null;
        }
    }

    public boolean isProvided() {
        return this.provided;
    }

    public final StandardJanusGraph get() {
        Preconditions.checkNotNull((Object)this.graph);
        return this.graph;
    }
}

