/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util.backpressure.builder;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.util.backpressure.PassAllQueryBackPressure;
import org.janusgraph.diskstorage.util.backpressure.QueryBackPressure;
import org.janusgraph.diskstorage.util.backpressure.SemaphoreProtectedReleaseQueryBackPressure;
import org.janusgraph.diskstorage.util.backpressure.SemaphoreQueryBackPressure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBackPressureBuilder {
    private static final Logger log = LoggerFactory.getLogger(QueryBackPressureBuilder.class);
    public static final String SEMAPHORE_QUERY_BACK_PRESSURE_CLASS = "semaphore";
    public static final String SEMAPHORE_RELEASE_PROTECTED_QUERY_BACK_PRESSURE_CLASS = "semaphoreReleaseProtected";
    public static final String PASS_ALL_QUERY_BACK_PRESSURE_CLASS = "passAll";

    private QueryBackPressureBuilder() {
    }

    public static QueryBackPressure build(Configuration configuration, String className, int backPressureLimit) {
        switch (className) {
            case "semaphore": {
                return new SemaphoreQueryBackPressure(backPressureLimit);
            }
            case "semaphoreReleaseProtected": {
                return new SemaphoreProtectedReleaseQueryBackPressure(backPressureLimit);
            }
            case "passAll": {
                return new PassAllQueryBackPressure();
            }
        }
        return QueryBackPressureBuilder.buildQueryBackPressureFromClassName(className, configuration, backPressureLimit);
    }

    private static QueryBackPressure buildQueryBackPressureFromClassName(String className, Configuration configuration, Integer backPressureLimit) {
        QueryBackPressure queryBackPressure;
        block11: {
            Class<?> queryBackPressureClass;
            try {
                queryBackPressureClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("No QueryBackPressure class found with class name: " + className);
            }
            if (!QueryBackPressure.class.isAssignableFrom(queryBackPressureClass)) {
                throw new IllegalArgumentException(className + "isn't a subclass of " + QueryBackPressure.class.getName());
            }
            Constructor<?> parameterlessConstructor = null;
            Constructor<?> constructorWithConfigurationParam = null;
            Constructor<?> constructorWithConfigurationAndBackpressureParams = null;
            for (Constructor<?> constructor : queryBackPressureClass.getDeclaredConstructors()) {
                if (constructor.getParameterCount() == 2) {
                    if (!Configuration.class.isAssignableFrom(constructor.getParameterTypes()[0]) || !Integer.class.isAssignableFrom(constructor.getParameterTypes()[1])) continue;
                    constructorWithConfigurationAndBackpressureParams = constructor;
                    continue;
                }
                if (constructor.getParameterCount() == 1) {
                    if (!Configuration.class.isAssignableFrom(constructor.getParameterTypes()[0])) continue;
                    constructorWithConfigurationParam = constructor;
                    continue;
                }
                if (constructor.getParameterCount() != 0) continue;
                parameterlessConstructor = constructor;
            }
            try {
                if (constructorWithConfigurationAndBackpressureParams != null) {
                    queryBackPressure = (QueryBackPressure)constructorWithConfigurationAndBackpressureParams.newInstance(configuration, backPressureLimit);
                    break block11;
                }
                if (constructorWithConfigurationParam != null) {
                    queryBackPressure = (QueryBackPressure)constructorWithConfigurationParam.newInstance(configuration);
                    break block11;
                }
                if (parameterlessConstructor != null) {
                    queryBackPressure = (QueryBackPressure)parameterlessConstructor.newInstance(new Object[0]);
                    break block11;
                }
                throw new IllegalArgumentException(className + " has neither public constructor which accepts " + Configuration.class.getName() + " and " + Integer.class.getName() + " nor constructor which accepts " + Configuration.class.getName() + " parameter only, nor parameterless public constructor.");
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("Couldn't create a new instance of " + className + ". Please, check that the constructor which accepts " + Configuration.class.getName() + " is public or there is a public parameterless constructor. If the necessary public constructor exists, please, check that invocation of this constructor doesn't throw an exception.", e);
            }
        }
        log.info("Initiated custom query back pressure {}", (Object)className);
        return queryBackPressure;
    }
}

