/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.keycolumnvalue;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRangeQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KCVSUtil {
    private static final Logger log = LoggerFactory.getLogger(KeyColumnValueStore.class);
    private static final int MAX_COLUMN_LENGTH = 32;
    private static final StaticBuffer START = BufferUtil.zeroBuffer(1);
    private static final StaticBuffer END = BufferUtil.oneBuffer(32);

    public static StaticBuffer get(KeyColumnValueStore store, StaticBuffer key, StaticBuffer column, StoreTransaction txh) throws BackendException {
        KeySliceQuery query = new KeySliceQuery(key, column, BufferUtil.nextBiggerBuffer(column)).setLimit(2);
        EntryList result = store.getSlice(query, txh);
        if (result.size() > 1) {
            log.warn("GET query returned more than 1 result: store {} | key {} | column {}", new Object[]{store.getName(), key, column});
        }
        if (result.isEmpty()) {
            return null;
        }
        return ((Entry)result.get(0)).getValueAs(StaticBuffer.STATIC_FACTORY);
    }

    public static KeyIterator getKeys(KeyColumnValueStore store, StoreFeatures features, int keyLength, int sliceLength, StoreTransaction txh) throws BackendException {
        return KCVSUtil.getKeys(store, new SliceQuery(BufferUtil.zeroBuffer(1), BufferUtil.oneBuffer(sliceLength)).setLimit(1), features, keyLength, txh);
    }

    public static KeyIterator getKeys(KeyColumnValueStore store, SliceQuery slice, StoreFeatures features, int keyLength, StoreTransaction txh) throws BackendException {
        if (features.hasUnorderedScan()) {
            return store.getKeys(slice, txh);
        }
        if (features.hasOrderedScan()) {
            return store.getKeys(new KeyRangeQuery(BufferUtil.zeroBuffer(1), BufferUtil.oneBuffer(keyLength), slice), txh);
        }
        throw new UnsupportedOperationException("Provided stores does not support scan operations: " + store);
    }

    public static boolean containsKeyColumn(KeyColumnValueStore store, StaticBuffer key, StaticBuffer column, StoreTransaction txh) throws BackendException {
        return KCVSUtil.get(store, key, column, txh) != null;
    }

    public static boolean containsKey(KeyColumnValueStore store, StaticBuffer key, StoreTransaction txh) throws BackendException {
        return KCVSUtil.containsKey(store, key, 32, txh);
    }

    public static boolean containsKey(KeyColumnValueStore store, StaticBuffer key, int maxColumnLength, StoreTransaction txh) throws BackendException {
        StaticBuffer end = maxColumnLength > 32 ? BufferUtil.oneBuffer(maxColumnLength) : END;
        return !store.getSlice(new KeySliceQuery(key, START, end).setLimit(1), txh).isEmpty();
    }

    public static boolean matches(SliceQuery query, StaticBuffer column) {
        return query.getSliceStart().compareTo(column) <= 0 && query.getSliceEnd().compareTo(column) > 0;
    }

    public static boolean matches(KeyRangeQuery query, StaticBuffer key, StaticBuffer column) {
        return KCVSUtil.matches(query, column) && query.getKeyStart().compareTo(key) <= 0 && query.getKeyEnd().compareTo(key) > 0;
    }

    public static Map<StaticBuffer, EntryList> emptyResults(Collection<StaticBuffer> keys) {
        HashMap<StaticBuffer, EntryList> result = new HashMap<StaticBuffer, EntryList>(keys.size());
        for (StaticBuffer key : keys) {
            result.put(key, EntryList.EMPTY_LIST);
        }
        return result;
    }
}

