/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import org.janusgraph.diskstorage.configuration.ConcurrentWriteConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.graphdb.database.idhandling.VariableLong;
import org.janusgraph.graphdb.database.serialize.DataOutput;

public class TransactionalConfiguration
implements WriteConfiguration {
    private final WriteConfiguration config;
    private final Map<String, Object> readValues;
    private final Map<String, Object> writtenValues;

    public TransactionalConfiguration(WriteConfiguration config) {
        Preconditions.checkNotNull((Object)config);
        this.config = config;
        this.readValues = new HashMap<String, Object>();
        this.writtenValues = new HashMap<String, Object>();
    }

    @Override
    public <O> void set(String key, O value) {
        this.writtenValues.put(key, value);
    }

    @Override
    public void remove(String key) {
        this.writtenValues.put(key, null);
    }

    @Override
    public WriteConfiguration copy() {
        return this.config.copy();
    }

    @Override
    public <O> O get(String key, Class<O> datatype) {
        Object value = this.writtenValues.get(key);
        if (value != null) {
            return (O)value;
        }
        value = this.readValues.get(key);
        if (value != null) {
            return (O)value;
        }
        value = this.config.get(key, datatype);
        this.readValues.put(key, value);
        return (O)value;
    }

    @Override
    public Iterable<String> getKeys(String prefix) {
        return Iterables.concat((Iterable)Iterables.filter(this.writtenValues.keySet(), s -> s != null && s.startsWith(prefix)), (Iterable)Iterables.filter(this.config.getKeys(prefix), s -> !this.writtenValues.containsKey(s)));
    }

    public void commit() {
        for (Map.Entry<String, Object> entry : this.writtenValues.entrySet()) {
            if (this.config instanceof ConcurrentWriteConfiguration && this.readValues.containsKey(entry.getKey())) {
                ((ConcurrentWriteConfiguration)this.config).set(entry.getKey(), entry.getValue(), this.readValues.get(entry.getKey()));
                continue;
            }
            this.config.set(entry.getKey(), entry.getValue());
        }
        this.rollback();
    }

    public void rollback() {
        this.writtenValues.clear();
        this.readValues.clear();
    }

    public boolean hasMutations() {
        return !this.writtenValues.isEmpty();
    }

    public void logMutations(DataOutput out) {
        Preconditions.checkArgument((boolean)this.hasMutations(), (Object)"No mutation to log");
        VariableLong.writePositive(out, this.writtenValues.size());
        for (Map.Entry<String, Object> entry : this.writtenValues.entrySet()) {
            out.writeObjectNotNull(entry.getKey());
            out.writeClassAndObject(entry.getValue());
        }
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }
}

