/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.util;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.RelationTypeIndex;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.management.GraphIndexStatusReport;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.database.management.RelationIndexStatusReport;
import org.janusgraph.graphdb.database.management.RelationIndexStatusWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ManagementUtil.class);

    public static void awaitGraphIndexUpdate(JanusGraph g, String indexName, long time, TemporalUnit unit) {
        ManagementUtil.awaitIndexUpdate(g, indexName, null, time, unit);
    }

    public static void awaitVertexIndexUpdate(JanusGraph g, String indexName, String relationTypeName, long time, TemporalUnit unit) {
        ManagementUtil.awaitIndexUpdate(g, indexName, relationTypeName, time, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void awaitIndexUpdate(JanusGraph g, String indexName, String relationTypeName, long time, TemporalUnit unit) {
        Preconditions.checkArgument((g != null && g.isOpen() ? 1 : 0) != 0, (Object)"Need to provide valid, open graph instance");
        Preconditions.checkArgument((time > 0L && unit != null ? 1 : 0) != 0, (Object)"Need to provide valid time interval");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)indexName), (Object)"Need to provide an index name");
        StandardJanusGraph graph = (StandardJanusGraph)g;
        TimestampProvider times = graph.getConfiguration().getTimestampProvider();
        Instant end = times.getTime().plus(Duration.of(time, unit));
        boolean isStable = false;
        while (times.getTime().isBefore(end)) {
            JanusGraphManagement management = graph.openManagement();
            try {
                Index idx;
                if (StringUtils.isNotBlank((CharSequence)relationTypeName)) {
                    idx = management.getRelationIndex(management.getRelationType(relationTypeName), indexName);
                    Preconditions.checkNotNull((Object)idx, (String)"Index could not be found: %s @ %s", (Object)indexName, (Object)relationTypeName);
                    isStable = idx.getIndexStatus().isStable();
                } else {
                    idx = management.getGraphIndex(indexName);
                    Preconditions.checkNotNull((Object)idx, (String)"Index could not be found: %s", (Object)indexName);
                    isStable = true;
                    for (PropertyKey key : idx.getFieldKeys()) {
                        if (idx.getIndexStatus(key).isStable()) continue;
                        isStable = false;
                    }
                }
            }
            finally {
                management.rollback();
            }
            if (isStable) break;
            try {
                times.sleepFor(Duration.ofMillis(500L));
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!isStable) {
            throw new JanusGraphException("Index did not stabilize within the given amount of time. For sufficiently long wait periods this is most likely caused by a failed/incorrectly shut down JanusGraph instance or a lingering transaction.");
        }
    }

    public static void forceRollbackAllTransactions(JanusGraph graph) {
        if (graph instanceof StandardJanusGraph) {
            for (JanusGraphTransaction janusGraphTransaction : ((StandardJanusGraph)graph).getOpenTransactions()) {
                janusGraphTransaction.rollback();
            }
        }
    }

    public static void forceCloseOtherInstances(JanusGraph graph) {
        String currentInstanceId = ((StandardJanusGraph)graph).getConfiguration().getUniqueGraphId();
        String currentInstanceIdWithSuffix = currentInstanceId + "(current)";
        JanusGraphManagement mgmt = graph.openManagement();
        mgmt.getOpenInstances().forEach(instanceId -> {
            if (!currentInstanceId.equals(instanceId) && !currentInstanceIdWithSuffix.equals(instanceId)) {
                mgmt.forceCloseInstance((String)instanceId);
            }
        });
        mgmt.commit();
    }

    public static void reindexAndEnableIndices(JanusGraph graph, List<String> nonEnabledGraphIndexNames, Map<String, String> nonEnabledRelationTypeIndexNamesAndTypes, long indexStatusTimeout) {
        nonEnabledGraphIndexNames.forEach(indexName -> ManagementUtil.awaitGraphIndexStatus(graph, indexName, indexStatusTimeout));
        nonEnabledRelationTypeIndexNamesAndTypes.forEach((indexName, indexedElementName) -> ManagementUtil.awaitVertexCentricIndexStatus(graph, indexName, indexedElementName, indexStatusTimeout));
        nonEnabledGraphIndexNames.forEach(indexName -> {
            try {
                LOG.info("Start re-indexing graph index {}", indexName);
                ManagementSystem schemaUpdateMgmt = (ManagementSystem)graph.openManagement();
                JanusGraphIndex index = schemaUpdateMgmt.getGraphIndex((String)indexName);
                schemaUpdateMgmt.updateIndex(index, SchemaAction.REINDEX).get();
                schemaUpdateMgmt.commit();
                LOG.info("Finished re-indexing graph index {}", indexName);
            }
            catch (Exception e) {
                LOG.error("Couldn't execute re-index for the graph index [{}]", indexName, (Object)e);
                throw new RuntimeException(e);
            }
        });
        nonEnabledRelationTypeIndexNamesAndTypes.forEach((indexName, indexedElementName) -> {
            try {
                LOG.info("Start re-indexing vertex-centric index {}", indexName);
                ManagementSystem schemaUpdateMgmt = (ManagementSystem)graph.openManagement();
                RelationTypeIndex index = schemaUpdateMgmt.getRelationIndex(schemaUpdateMgmt.getRelationType((String)indexedElementName), (String)indexName);
                schemaUpdateMgmt.updateIndex(index, SchemaAction.REINDEX).get();
                schemaUpdateMgmt.commit();
                LOG.info("Finished re-indexing vertex-centric index {}", indexName);
            }
            catch (Exception e) {
                LOG.error("Couldn't execute re-index for the vertex-centric index [{}]", indexName, (Object)e);
                throw new RuntimeException(e);
            }
        });
    }

    public static void forceEnableIndices(JanusGraph graph, List<String> nonEnabledGraphIndexNames, Map<String, String> nonEnabledRelationTypeIndexNamesAndTypes, long indexStatusTimeout) {
        nonEnabledGraphIndexNames.forEach(indexName -> {
            try {
                ManagementUtil.awaitGraphIndexStatus(graph, indexName, indexStatusTimeout);
            }
            catch (Exception e) {
                LOG.warn("Await for status update of the graph index {} finished with exception", indexName, (Object)e);
            }
        });
        nonEnabledRelationTypeIndexNamesAndTypes.forEach((indexName, indexedElementName) -> {
            try {
                ManagementUtil.awaitVertexCentricIndexStatus(graph, indexName, indexedElementName, indexStatusTimeout);
            }
            catch (Exception e) {
                LOG.warn("Await for status update of the vertex-centric index {} finished with exception", indexName, (Object)e);
            }
        });
        nonEnabledGraphIndexNames.forEach(indexName -> {
            try {
                LOG.info("Start force-enabling graph index {}", indexName);
                ManagementSystem schemaUpdateMgmt = (ManagementSystem)graph.openManagement();
                JanusGraphIndex index = schemaUpdateMgmt.getGraphIndex((String)indexName);
                schemaUpdateMgmt.updateIndex(index, SchemaAction.ENABLE_INDEX).get();
                schemaUpdateMgmt.commit();
                LOG.info("Finished force-enabling graph index {}", indexName);
            }
            catch (Exception e) {
                LOG.error("Couldn't execute force-enable for the graph index [{}]", indexName, (Object)e);
                throw new RuntimeException(e);
            }
        });
        nonEnabledRelationTypeIndexNamesAndTypes.forEach((indexName, indexedElementName) -> {
            try {
                LOG.info("Start force-enabling vertex-centric index {}", indexName);
                ManagementSystem schemaUpdateMgmt = (ManagementSystem)graph.openManagement();
                RelationTypeIndex index = schemaUpdateMgmt.getRelationIndex(schemaUpdateMgmt.getRelationType((String)indexedElementName), (String)indexName);
                schemaUpdateMgmt.updateIndex(index, SchemaAction.ENABLE_INDEX).get();
                schemaUpdateMgmt.commit();
                LOG.info("Finished force-enabling vertex-centric index {}", indexName);
            }
            catch (Exception e) {
                LOG.error("Couldn't execute force-enable for the vertex-centric index [{}]", indexName, (Object)e);
                throw new RuntimeException(e);
            }
        });
    }

    public static void awaitVertexCentricIndexStatus(JanusGraph janusGraph, String indexName, String indexedElement, long indexStatusTimeout) {
        RelationIndexStatusReport relationIndexStatusReport;
        try {
            relationIndexStatusReport = ((RelationIndexStatusWatcher)ManagementSystem.awaitRelationIndexStatus(janusGraph, indexName, indexedElement).timeout(indexStatusTimeout, ChronoUnit.MILLIS)).call();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (!relationIndexStatusReport.getSucceeded()) {
            LOG.error("Await wasn't successful for index [{}]. Actual status [{}]. Time elapsed [{}]. Target statuses [{}]", new Object[]{indexName, relationIndexStatusReport.getActualStatus().toString(), relationIndexStatusReport.getElapsed().toString(), StringUtils.join((Object[])new List[]{relationIndexStatusReport.getTargetStatuses()})});
            throw new IllegalStateException("Couldn't await for vertex-centric index status in time [" + indexName + "]");
        }
    }

    public static void awaitGraphIndexStatus(JanusGraph janusGraph, String indexName, long indexStatusTimeout) {
        GraphIndexStatusReport graphIndexStatusReport;
        try {
            graphIndexStatusReport = ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus(janusGraph, indexName).timeout(indexStatusTimeout, ChronoUnit.MILLIS)).call();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (!graphIndexStatusReport.getSucceeded()) {
            LOG.warn("Await wasn't successful for index [{}]. Covered keys [{}]. Not covered keys [{}]. Time elapsed [{}]. Target statuses [{}]", new Object[]{indexName, StringUtils.join((Object[])new Map[]{graphIndexStatusReport.getConvergedKeys()}), StringUtils.join((Object[])new Map[]{graphIndexStatusReport.getNotConvergedKeys()}), graphIndexStatusReport.getElapsed().toString(), StringUtils.join((Object[])new List[]{graphIndexStatusReport.getTargetStatuses()})});
            throw new IllegalStateException("Couldn't await for graph-centric index status in time [" + indexName + "]");
        }
    }

    public static boolean isIndexHasStatus(Index index, SchemaStatus status) {
        if (index instanceof JanusGraphIndex) {
            return ManagementUtil.isGraphIndexHasStatus((JanusGraphIndex)index, status);
        }
        if (index instanceof RelationTypeIndex) {
            return ManagementUtil.isRelationIndexHasStatus((RelationTypeIndex)index, status);
        }
        throw new IllegalStateException("Unexpected index type: " + index.getClass() + ", indexName: " + index.name());
    }

    public static boolean isGraphIndexHasStatus(JanusGraphIndex graphIndex, SchemaStatus status) {
        for (PropertyKey propertyKey : graphIndex.getFieldKeys()) {
            if (status.equals((Object)graphIndex.getIndexStatus(propertyKey))) continue;
            return false;
        }
        return true;
    }

    public static boolean isRelationIndexHasStatus(RelationTypeIndex relationTypeIndex, SchemaStatus status) {
        return status.equals((Object)relationTypeIndex.getIndexStatus());
    }
}

