/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema.json.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.UnhandledException;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.json.parser.JsonParameterParser;

public class EnumJsonParameterParser
implements JsonParameterParser {
    @Override
    public Parameter parse(String key, String value) {
        return Parameter.of(key, this.toEnum(value));
    }

    private Object toEnum(String value) {
        int indexOfValue = value.lastIndexOf(".");
        if (indexOfValue == -1) {
            throw new AssertionError((Object)(value + " isn't a valid enum value. Please use full path (package + class + value) to enum value. Example: org.janusgraph.core.schema.Mapping.TEXT"));
        }
        try {
            Class<?> enumClass = Class.forName(value.substring(0, indexOfValue));
            Method method = enumClass.getMethod("valueOf", String.class);
            return method.invoke(null, value.substring(indexOfValue + 1));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnhandledException((Throwable)e);
        }
    }
}

