/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema.json.creator.index;

import org.apache.commons.collections.CollectionUtils;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.json.creator.JsonSchemaCreationContext;
import org.janusgraph.core.schema.json.creator.index.AbstractJsonIndexCreator;
import org.janusgraph.core.schema.json.definition.index.AbstractJsonIndexDefinition;
import org.janusgraph.core.schema.json.definition.index.AbstractJsonVertexCentricIndexDefinition;

public abstract class AbstractJsonVertexCentricIndexCreator<T extends AbstractJsonVertexCentricIndexDefinition>
extends AbstractJsonIndexCreator<T> {
    private static final PropertyKey[] EMPTY_PROPERTY_KEYS = new PropertyKey[0];

    @Override
    protected boolean containsIndex(T definition, JsonSchemaCreationContext context) {
        JanusGraphManagement graphManagement = context.getGraphManagement();
        RelationType relationType = graphManagement.getRelationType(this.getIndexedElementName(definition));
        return graphManagement.containsRelationIndex(relationType, ((AbstractJsonIndexDefinition)definition).getName());
    }

    protected PropertyKey[] toPropertyKeys(T definition, JsonSchemaCreationContext context) {
        if (CollectionUtils.isEmpty(((AbstractJsonVertexCentricIndexDefinition)definition).getPropertyKeys())) {
            return EMPTY_PROPERTY_KEYS;
        }
        return (PropertyKey[])((AbstractJsonVertexCentricIndexDefinition)definition).getPropertyKeys().stream().map(propertyKey -> context.getGraphManagement().getPropertyKey((String)propertyKey)).toArray(PropertyKey[]::new);
    }

    protected abstract String getIndexedElementName(T var1);
}

