/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.Namifiable;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.schema.IndicesActivationType;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.RelationTypeIndex;
import org.janusgraph.core.schema.SchemaInitStrategy;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.core.schema.json.creator.GeneralJsonSchemaCreator;
import org.janusgraph.core.schema.json.creator.JsonSchemaCreationContext;
import org.janusgraph.core.schema.json.creator.SchemaCreationException;
import org.janusgraph.core.schema.json.definition.JsonSchemaDefinition;
import org.janusgraph.core.schema.json.definition.index.AbstractJsonGraphCentricIndexDefinition;
import org.janusgraph.core.schema.json.definition.index.AbstractJsonIndexDefinition;
import org.janusgraph.core.schema.json.definition.index.AbstractJsonVertexCentricIndexDefinition;
import org.janusgraph.core.schema.json.definition.index.JsonVertexCentricEdgeIndexDefinition;
import org.janusgraph.core.schema.json.definition.index.JsonVertexCentricPropertyIndexDefinition;
import org.janusgraph.core.util.JsonUtil;
import org.janusgraph.core.util.ManagementUtil;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaInitStrategy
implements SchemaInitStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(JsonSchemaInitStrategy.class);

    @Override
    public JanusGraph initializeSchemaAndStart(GraphDatabaseConfiguration graphDatabaseConfiguration) {
        StandardJanusGraph graph;
        block5: {
            graph = new StandardJanusGraph(graphDatabaseConfiguration);
            try {
                if (StringUtils.isNotEmpty((CharSequence)graphDatabaseConfiguration.getSchemaInitJsonString())) {
                    JsonSchemaInitStrategy.initializeSchemaFromString(graph, graphDatabaseConfiguration.getSchemaInitJsonString());
                    break block5;
                }
                if (StringUtils.isNotEmpty((CharSequence)graphDatabaseConfiguration.getSchemaInitJsonFile())) {
                    JsonSchemaInitStrategy.initializeSchemaFromFile(graph, graphDatabaseConfiguration.getSchemaInitJsonFile());
                    break block5;
                }
                throw new SchemaCreationException("When JSON schema initialization is enabled it's necessary to provide either JSON file or string for schema initialization.");
            }
            catch (Throwable throwable) {
                graph.close();
                if (throwable instanceof SchemaCreationException) {
                    throw (SchemaCreationException)throwable;
                }
                throw new SchemaCreationException(throwable);
            }
        }
        return graph;
    }

    public static void initializeSchemaFromFile(JanusGraph graph, String jsonSchemaFilePath) {
        GraphDatabaseConfiguration graphDatabaseConfiguration = ((StandardJanusGraph)graph).getConfiguration();
        IndicesActivationType indicesActivationType = graphDatabaseConfiguration.getSchemaInitJsonIndicesActivationType();
        boolean createSchemaElements = !graphDatabaseConfiguration.getSchemaInitJsonSkipElements();
        boolean createSchemaIndices = !graphDatabaseConfiguration.getSchemaInitJsonSkipIndices();
        long indexStatusTimeout = graphDatabaseConfiguration.getSchemaInitJsonIndexStatusAwaitTimeout();
        JsonSchemaInitStrategy.initializeSchemaFromFile(graph, createSchemaElements, createSchemaIndices, indicesActivationType, true, graphDatabaseConfiguration.getSchemaInitJsonForceCloseOtherInstances(), indexStatusTimeout, jsonSchemaFilePath);
    }

    public static void initializeSchemaFromString(JanusGraph graph, String jsonSchemaString) {
        GraphDatabaseConfiguration graphDatabaseConfiguration = ((StandardJanusGraph)graph).getConfiguration();
        IndicesActivationType indicesActivationType = graphDatabaseConfiguration.getSchemaInitJsonIndicesActivationType();
        boolean createSchemaElements = !graphDatabaseConfiguration.getSchemaInitJsonSkipElements();
        boolean createSchemaIndices = !graphDatabaseConfiguration.getSchemaInitJsonSkipIndices();
        long indexStatusTimeout = graphDatabaseConfiguration.getSchemaInitJsonIndexStatusAwaitTimeout();
        JsonSchemaInitStrategy.initializeSchemaFromString(graph, createSchemaElements, createSchemaIndices, indicesActivationType, true, graphDatabaseConfiguration.getSchemaInitJsonForceCloseOtherInstances(), indexStatusTimeout, jsonSchemaString);
    }

    public static void initializeSchemaFromFile(JanusGraph graph, boolean createSchemaElements, boolean createSchemaIndices, IndicesActivationType indicesActivationType, boolean forceRollBackActiveTransactions, boolean forceCloseOtherInstances, long indexStatusTimeout, String jsonSchemaFilePath) {
        JsonSchemaDefinition generalDefinition;
        try {
            generalDefinition = JsonUtil.jsonFilePathToObject(jsonSchemaFilePath, JsonSchemaDefinition.class);
        }
        catch (IOException e) {
            throw new SchemaCreationException(e);
        }
        JsonSchemaInitStrategy.initializeSchema(graph, createSchemaElements, createSchemaIndices, indicesActivationType, forceRollBackActiveTransactions, forceCloseOtherInstances, indexStatusTimeout, generalDefinition);
    }

    public static void initializeSchemaFromString(JanusGraph graph, boolean createSchemaElements, boolean createSchemaIndices, IndicesActivationType indicesActivationType, boolean forceRollBackActiveTransactions, boolean forceCloseOtherInstances, long indexStatusTimeout, String jsonSchemaString) {
        JsonSchemaDefinition generalDefinition;
        try {
            generalDefinition = JsonUtil.jsonStringToObject(jsonSchemaString, JsonSchemaDefinition.class);
        }
        catch (IOException e) {
            throw new SchemaCreationException(e);
        }
        JsonSchemaInitStrategy.initializeSchema(graph, createSchemaElements, createSchemaIndices, indicesActivationType, forceRollBackActiveTransactions, forceCloseOtherInstances, indexStatusTimeout, generalDefinition);
    }

    public static void initializeSchema(JanusGraph graph, boolean createSchemaElements, boolean createSchemaIndices, IndicesActivationType indicesActivationType, boolean forceRollBackActiveTransactions, boolean forceCloseOtherInstances, long indexStatusTimeout, JsonSchemaDefinition generalDefinition) {
        LOG.info("Starting schema initialization.");
        if (forceCloseOtherInstances) {
            ManagementUtil.forceCloseOtherInstances(graph);
        }
        if (forceRollBackActiveTransactions) {
            ManagementUtil.forceRollbackAllTransactions(graph);
        }
        ManagementSystem schemaCreationMgmt = (ManagementSystem)graph.openManagement();
        JsonSchemaCreationContext schemaCreationContext = new JsonSchemaCreationContext(schemaCreationMgmt, createSchemaElements, createSchemaIndices);
        GeneralJsonSchemaCreator generalJsonSchemaCreator = new GeneralJsonSchemaCreator();
        generalJsonSchemaCreator.create(generalDefinition, schemaCreationContext);
        List<String> updatedButNonEnabledIndicesNames = schemaCreationContext.getCreatedOrUpdatedIndices().stream().filter(indexDefinition -> !JsonSchemaInitStrategy.isIndexEnabled(indexDefinition, schemaCreationMgmt)).map(AbstractJsonIndexDefinition::getName).collect(Collectors.toList());
        schemaCreationMgmt.commit();
        JsonSchemaInitStrategy.processIndicesActivation(graph, updatedButNonEnabledIndicesNames, indicesActivationType, indexStatusTimeout);
        LOG.info("Schema initialization completed.");
    }

    private static void processIndicesActivation(JanusGraph graph, List<String> updatedButNonEnabledIndicesNames, IndicesActivationType indicesActivationType, long indexStatusTimeout) {
        if (IndicesActivationType.SKIP_ACTIVATION.equals(indicesActivationType)) {
            return;
        }
        ManagementSystem schemaFetchMgmt = (ManagementSystem)graph.openManagement();
        List<JanusGraphIndex> nonEnabledGraphIndices = schemaFetchMgmt.getGraphIndices(SchemaStatus.ENABLED);
        List<RelationTypeIndex> nonEnabledRelationTypeIndices = schemaFetchMgmt.getVertexCentricIndices(SchemaStatus.ENABLED);
        if (IndicesActivationType.REINDEX_AND_ENABLE_UPDATED_ONLY.equals(indicesActivationType) || IndicesActivationType.FORCE_ENABLE_UPDATED_ONLY.equals(indicesActivationType)) {
            List<JanusGraphIndex> nonEnabledGraphIndicesCopy = nonEnabledGraphIndices;
            List<RelationTypeIndex> nonEnabledRelationTypeIndicesCopy = nonEnabledRelationTypeIndices;
            nonEnabledGraphIndices = new ArrayList<JanusGraphIndex>(nonEnabledGraphIndices.size());
            nonEnabledRelationTypeIndices = new ArrayList<RelationTypeIndex>(nonEnabledRelationTypeIndices.size());
            for (JanusGraphIndex janusGraphIndex : nonEnabledGraphIndicesCopy) {
                if (!updatedButNonEnabledIndicesNames.contains(janusGraphIndex.name())) continue;
                nonEnabledGraphIndices.add(janusGraphIndex);
            }
            for (RelationTypeIndex relationTypeIndex : nonEnabledRelationTypeIndicesCopy) {
                if (!updatedButNonEnabledIndicesNames.contains(relationTypeIndex.name())) continue;
                nonEnabledRelationTypeIndices.add(relationTypeIndex);
            }
        }
        List<String> nonEnabledGraphIndexNames = nonEnabledGraphIndices.stream().map(JanusGraphIndex::name).collect(Collectors.toList());
        Map<String, String> nonEnabledRelationTypeIndexNamesAndTypes = nonEnabledRelationTypeIndices.stream().collect(Collectors.toMap(Namifiable::name, o -> o.getType().name()));
        schemaFetchMgmt.rollback();
        List nonEnabledIndexNames = Stream.concat(nonEnabledGraphIndexNames.stream(), nonEnabledRelationTypeIndexNamesAndTypes.keySet().stream()).collect(Collectors.toList());
        if (!nonEnabledIndexNames.isEmpty()) {
            String string = String.join((CharSequence)", ", nonEnabledIndexNames);
            if (!nonEnabledIndexNames.isEmpty() && LOG.isInfoEnabled()) {
                LOG.info("Found {} non-enabled indices. Awaiting for their status updates. Indexes [{}].", (Object)nonEnabledIndexNames.size(), (Object)string);
            }
            if (IndicesActivationType.REINDEX_AND_ENABLE_UPDATED_ONLY.equals(indicesActivationType) || IndicesActivationType.REINDEX_AND_ENABLE_NON_ENABLED.equals(indicesActivationType)) {
                ManagementUtil.reindexAndEnableIndices(graph, nonEnabledGraphIndexNames, nonEnabledRelationTypeIndexNamesAndTypes, indexStatusTimeout);
            } else if (IndicesActivationType.FORCE_ENABLE_UPDATED_ONLY.equals(indicesActivationType) || IndicesActivationType.FORCE_ENABLE_NON_ENABLED.equals(indicesActivationType)) {
                ManagementUtil.forceEnableIndices(graph, nonEnabledGraphIndexNames, nonEnabledRelationTypeIndexNamesAndTypes, indexStatusTimeout);
            } else {
                throw new IllegalStateException("Unknown indicesActivationType: " + indicesActivationType);
            }
        }
    }

    private static boolean isIndexEnabled(AbstractJsonIndexDefinition createdIndexesDefinition, JanusGraphManagement graphManagement) {
        return JsonSchemaInitStrategy.isIndexHasStatus(createdIndexesDefinition, graphManagement, SchemaStatus.ENABLED);
    }

    private static boolean isIndexHasStatus(AbstractJsonIndexDefinition createdIndexesDefinition, JanusGraphManagement graphManagement, SchemaStatus schemaStatus) {
        if (createdIndexesDefinition instanceof AbstractJsonVertexCentricIndexDefinition) {
            String indexedElement;
            AbstractJsonVertexCentricIndexDefinition vertexCentricIndex = (AbstractJsonVertexCentricIndexDefinition)createdIndexesDefinition;
            if (vertexCentricIndex instanceof JsonVertexCentricEdgeIndexDefinition) {
                indexedElement = ((JsonVertexCentricEdgeIndexDefinition)vertexCentricIndex).getIndexedEdgeLabel();
            } else if (vertexCentricIndex instanceof JsonVertexCentricPropertyIndexDefinition) {
                indexedElement = ((JsonVertexCentricPropertyIndexDefinition)vertexCentricIndex).getIndexedPropertyKey();
            } else {
                throw new SchemaCreationException("Unknown index type definition: " + createdIndexesDefinition.getClass().getName());
            }
            RelationType relationType = graphManagement.getRelationType(indexedElement);
            RelationTypeIndex relationIndex = graphManagement.getRelationIndex(relationType, vertexCentricIndex.getName());
            return schemaStatus.equals((Object)relationIndex.getIndexStatus());
        }
        if (createdIndexesDefinition instanceof AbstractJsonGraphCentricIndexDefinition) {
            JanusGraphIndex janusGraphIndex = graphManagement.getGraphIndex(createdIndexesDefinition.getName());
            for (PropertyKey propertyKey : janusGraphIndex.getFieldKeys()) {
                if (schemaStatus.equals((Object)janusGraphIndex.getIndexStatus(propertyKey))) continue;
                return false;
            }
            return true;
        }
        throw new SchemaCreationException("Unknown index type definition: " + createdIndexesDefinition.getClass().getName());
    }
}

