/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.system;

import com.google.common.base.Preconditions;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.util.system.LoggerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationLint {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationLint.class);

    public static void main(String[] args) throws IOException {
        if (1 != args.length) {
            System.err.println("Usage: ConfigurationLint janusgraph.properties");
            System.err.println("  Reads the supplied config file from disk and checks for unknown options.");
            System.exit(1);
        }
        log.info("Checking " + LoggerUtil.sanitizeAndLaunder(args[0]));
        Status s = ConfigurationLint.validate(args[0]);
        if (0 == s.errors) {
            log.info(s.toString());
        } else {
            log.warn(s.toString());
        }
        System.exit(Math.min(s.errors, 127));
    }

    public static Status validate(String filename) throws IOException {
        PropertiesConfiguration apc;
        try (FileInputStream fis = new FileInputStream(filename);){
            new Properties().load(fis);
        }
        try {
            apc = new PropertiesConfiguration(filename);
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        Iterator iterator = apc.getKeys();
        int totalKeys = 0;
        int keysVerified = 0;
        while (iterator.hasNext()) {
            ++totalKeys;
            String key = (String)iterator.next();
            String value = apc.getString(key);
            try {
                ConfigOption opt;
                ConfigElement.PathIdentifier pid = ConfigElement.parse(GraphDatabaseConfiguration.ROOT_NS, key);
                Preconditions.checkState((null != pid ? 1 : 0) != 0);
                Preconditions.checkState((null != pid.element ? 1 : 0) != 0);
                if (!pid.element.isOption()) {
                    log.warn("Config key {} is a namespace (only options can be keys)", (Object)key);
                    continue;
                }
                try {
                    opt = (ConfigOption)pid.element;
                }
                catch (RuntimeException re) {
                    log.warn("Config key {} maps to the element {}, but it could not be cast to an option", new Object[]{key, pid.element, re});
                    continue;
                }
                try {
                    Object o = new CommonsConfiguration((Configuration)apc).get(key, opt.getDatatype());
                    opt.verify(o);
                    ++keysVerified;
                }
                catch (RuntimeException re) {
                    log.warn("Config key {} is recognized, but its value {} could not be validated", (Object)key, (Object)value);
                    log.debug("Validation exception on {}={} follows", new Object[]{key, value, re});
                }
            }
            catch (RuntimeException re) {
                log.warn("Unknown config key {}", (Object)key);
            }
        }
        return new Status(totalKeys, totalKeys - keysVerified);
    }

    public static class Status {
        private final int total;
        private final int errors;

        public Status(int total, int errors) {
            this.total = total;
            this.errors = errors;
        }

        public int getTotalSettingCount() {
            return this.total;
        }

        public int getErrorSettingCount() {
            return this.errors;
        }

        public String toString() {
            if (0 == this.errors) {
                return String.format("[ConfigurationLint.Status: OK: %d settings validated]", this.total);
            }
            return String.format("[ConfigurationLint.Status: WARNING: %d settings failed to validate out of %d total]", this.errors, this.total);
        }
    }
}

