/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ObjectAccumulator<K> {
    private final HashMap<K, Counter> countMap;

    public ObjectAccumulator() {
        this.countMap = new HashMap();
    }

    public ObjectAccumulator(int initialSize) {
        this.countMap = new HashMap(initialSize);
    }

    public double incBy(K o, double inc) {
        Counter c = this.countMap.computeIfAbsent(o, k -> new Counter());
        c.count += inc;
        return c.count;
    }

    public double getCount(K o) {
        Counter c = this.countMap.get(o);
        if (c == null) {
            return 0.0;
        }
        return c.count;
    }

    public double getCountSave(K o) {
        Counter c = this.countMap.get(o);
        if (c == null) {
            throw new NoSuchElementException("Object [" + o + "] does not exist");
        }
        return c.count;
    }

    public Set<K> getObjects() {
        return this.countMap.keySet();
    }

    public int numObjects() {
        return this.countMap.size();
    }

    public boolean hasObject(K obj) {
        return this.countMap.containsKey(obj);
    }

    public boolean removeObject(K obj) {
        return this.countMap.remove(obj) != null;
    }

    public K getMaxObject() {
        K result = null;
        double count = Double.MIN_VALUE;
        for (Map.Entry<K, Counter> entry : this.countMap.entrySet()) {
            if (!(entry.getValue().count >= count)) continue;
            count = entry.getValue().count;
            result = entry.getKey();
        }
        return result;
    }

    class Counter {
        double count = 0.0;

        Counter() {
        }
    }
}

