/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.vertices;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.query.vertex.VertexCentricQueryBuilder;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.util.ElementHelper;
import org.janusgraph.graphdb.vertices.CacheVertex;
import org.janusgraph.util.datastructures.Retriever;

public class PreloadedVertex
extends CacheVertex {
    public static final Retriever<SliceQuery, EntryList> EMPTY_RETRIEVER = input -> EntryList.EMPTY_LIST;
    private PropertyMixing mixin = NO_MIXIN;
    private AccessCheck accessCheck = DEFAULT_CHECK;
    public static final AccessCheck DEFAULT_CHECK = new AccessCheck(){

        @Override
        public final void accessEdges() {
            throw GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated();
        }

        @Override
        public final void accessProperties() {
            throw GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated();
        }

        @Override
        public void accessSetProperty() {
            throw GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated();
        }

        @Override
        public Retriever<SliceQuery, EntryList> retrieveSliceQuery() {
            return EMPTY_RETRIEVER;
        }
    };
    public static final AccessCheck CLOSEDSTAR_CHECK = new AccessCheck(){
        private final Retriever<SliceQuery, EntryList> EXCEPTION_RETRIEVER = input -> {
            throw new UnsupportedOperationException("Cannot access data that hasn't been preloaded.");
        };

        @Override
        public final void accessEdges() {
        }

        @Override
        public final void accessProperties() {
        }

        @Override
        public void accessSetProperty() {
        }

        @Override
        public Retriever<SliceQuery, EntryList> retrieveSliceQuery() {
            return this.EXCEPTION_RETRIEVER;
        }
    };
    public static final AccessCheck OPENSTAR_CHECK = new AccessCheck(){

        @Override
        public final void accessEdges() {
        }

        @Override
        public final void accessProperties() {
        }

        @Override
        public void accessSetProperty() {
        }

        @Override
        public Retriever<SliceQuery, EntryList> retrieveSliceQuery() {
            return EMPTY_RETRIEVER;
        }
    };
    private static final PropertyMixing NO_MIXIN = new PropertyMixing(){

        @Override
        public <V> Iterator<VertexProperty<V>> properties(String ... keys) {
            return Collections.emptyIterator();
        }

        @Override
        public boolean supports(String key) {
            return false;
        }

        @Override
        public <V> JanusGraphVertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value) {
            throw new UnsupportedOperationException("Provided key is not supported: " + key);
        }
    };

    public PreloadedVertex(StandardJanusGraphTx tx, long id, byte lifecycle) {
        super(tx, id, lifecycle);
        assert (lifecycle == 2) : "Invalid lifecycle encountered: " + lifecycle;
    }

    public void setPropertyMixing(PropertyMixing mixin) {
        Preconditions.checkNotNull((Object)mixin);
        Preconditions.checkArgument((this.mixin == NO_MIXIN ? 1 : 0) != 0, (Object)"A property mixing has already been set");
        this.mixin = mixin;
    }

    public void setAccessCheck(AccessCheck accessCheck) {
        Preconditions.checkArgument((accessCheck != null ? 1 : 0) != 0);
        this.accessCheck = accessCheck;
    }

    @Override
    public void addToQueryCache(SliceQuery query, EntryList entries) {
        super.addToQueryCache(query, entries);
    }

    public EntryList getFromCache(SliceQuery query) {
        return (EntryList)this.queryCache.get(query);
    }

    @Override
    public List<InternalRelation> getAddedRelations(Predicate<InternalRelation> query) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public VertexCentricQueryBuilder query() {
        if (super.getQueryCacheSize() > 0) {
            return (VertexCentricQueryBuilder)super.query().queryOnlyGivenVertex();
        }
        throw GraphComputer.Exceptions.adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated();
    }

    @Override
    public boolean hasLoadedRelations(SliceQuery query) {
        return true;
    }

    @Override
    public boolean hasRemovedRelations() {
        return false;
    }

    @Override
    public boolean hasAddedRelations() {
        return false;
    }

    @Override
    public EntryList loadRelations(SliceQuery query, Retriever<SliceQuery, EntryList> lookup) {
        return super.loadRelations(query, this.accessCheck.retrieveSliceQuery());
    }

    @Override
    public <V> JanusGraphVertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        this.accessCheck.accessSetProperty();
        JanusGraphVertexProperty<V> p = this.mixin.property(cardinality, key, value);
        ElementHelper.attachProperties(p, keyValues);
        return p;
    }

    @Override
    public <V> JanusGraphVertexProperty<V> property(String key, V value, Object ... keyValues) {
        return this.property(VertexProperty.Cardinality.single, key, (Object)value, keyValues);
    }

    @Override
    public <V> Iterator<VertexProperty<V>> properties(String ... keys) {
        this.accessCheck.accessProperties();
        if (this.mixin == NO_MIXIN) {
            return super.properties(keys);
        }
        if (keys != null && keys.length > 0) {
            int count = 0;
            for (String key : keys) {
                if (!this.mixin.supports(key)) continue;
                ++count;
            }
            if (count == 0 || !this.mixin.properties(keys).hasNext()) {
                return super.properties(keys);
            }
            if (count == keys.length) {
                return this.mixin.properties(keys);
            }
        }
        return Iterators.concat(super.properties(keys), this.mixin.properties(keys));
    }

    @Override
    public JanusGraphEdge addEdge(String s, Vertex vertex, Object ... keyValues) {
        throw GraphComputer.Exceptions.adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated();
    }

    @Override
    public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
        this.accessCheck.accessEdges();
        return super.edges(direction, edgeLabels);
    }

    @Override
    public void remove() {
    }

    @Override
    public void removeRelation(InternalRelation e) {
        throw GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated();
    }

    @Override
    public boolean addRelation(InternalRelation e) {
        throw GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated();
    }

    public static interface PropertyMixing {
        public <V> Iterator<VertexProperty<V>> properties(String ... var1);

        public boolean supports(String var1);

        public <V> JanusGraphVertexProperty<V> property(VertexProperty.Cardinality var1, String var2, V var3);
    }

    public static interface AccessCheck {
        public void accessEdges();

        public void accessProperties();

        public void accessSetProperty();

        public Retriever<SliceQuery, EntryList> retrieveSliceQuery();
    }
}

