/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphEdge;

public class AllEdgesIterator
implements Iterator<Edge> {
    private final Set<? extends Vertex> vertices;
    private final Iterator<? extends Vertex> vertexIterator;
    private Iterator<Edge> currentEdges = Collections.emptyIterator();
    private Edge next;

    public AllEdgesIterator(Iterator<? extends Vertex> vertexIterator) {
        this.vertexIterator = vertexIterator;
        this.vertices = null;
        this.next = this.findNext();
    }

    public AllEdgesIterator(Set<? extends Vertex> vertices) {
        this.vertexIterator = vertices.iterator();
        this.vertices = vertices;
        this.next = this.findNext();
    }

    private Edge findNext() {
        JanusGraphEdge rel = null;
        while (rel == null) {
            if (this.currentEdges.hasNext()) {
                rel = (JanusGraphEdge)this.currentEdges.next();
                if (this.vertices == null || this.vertices.contains(rel.vertex(Direction.IN))) continue;
                rel = null;
                continue;
            }
            if (!this.vertexIterator.hasNext()) break;
            Vertex nextVertex = this.vertexIterator.next();
            this.currentEdges = nextVertex.edges(Direction.OUT, new String[0]);
        }
        return rel;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Edge next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Edge current = this.next;
        this.next = this.findNext();
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removals are not supported");
    }
}

