/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.graphdb.database.management.ModifierType;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.IndexField;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.SchemaSource;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;

public class TypeUtil {
    public static boolean hasSimpleInternalVertexKeyIndex(JanusGraphRelation rel) {
        return rel instanceof JanusGraphVertexProperty && TypeUtil.hasSimpleInternalVertexKeyIndex((JanusGraphVertexProperty)rel);
    }

    public static void checkTypeName(JanusGraphSchemaCategory category, String name) {
        switch (category) {
            case EDGELABEL: 
            case VERTEXLABEL: {
                if (name == null) {
                    throw Element.Exceptions.labelCanNotBeNull();
                }
                if (!StringUtils.isBlank((String)name)) break;
                throw Element.Exceptions.labelCanNotBeEmpty();
            }
            case PROPERTYKEY: {
                if (name == null) {
                    throw Property.Exceptions.propertyKeyCanNotBeNull();
                }
                if (!StringUtils.isBlank((String)name)) break;
                throw Property.Exceptions.propertyKeyCanNotBeEmpty();
            }
            case GRAPHINDEX: {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (String)"Index name cannot be empty: %s", (Object[])new Object[]{name});
                break;
            }
            default: {
                throw new AssertionError((Object)category);
            }
        }
    }

    public static boolean hasSimpleInternalVertexKeyIndex(JanusGraphVertexProperty prop) {
        return TypeUtil.hasSimpleInternalVertexKeyIndex(prop.propertyKey());
    }

    public static boolean hasSimpleInternalVertexKeyIndex(PropertyKey key) {
        InternalRelationType type = (InternalRelationType)((Object)key);
        for (IndexType index : type.getKeyIndexes()) {
            if (index.getElement() != ElementCategory.VERTEX || !index.isCompositeIndex() || !index.indexesKey(key)) continue;
            return true;
        }
        return false;
    }

    public static InternalRelationType getBaseType(InternalRelationType type) {
        InternalRelationType baseType = type.getBaseType();
        if (baseType == null) {
            return type;
        }
        return baseType;
    }

    public static Set<PropertyKey> getIndexedKeys(IndexType index) {
        HashSet s = Sets.newHashSet();
        for (IndexField f : index.getFieldKeys()) {
            s.add(f.getFieldKey());
        }
        return s;
    }

    public static List<CompositeIndexType> getUniqueIndexes(PropertyKey key) {
        ArrayList<CompositeIndexType> indexes = new ArrayList<CompositeIndexType>();
        for (IndexType index : ((InternalRelationType)((Object)key)).getKeyIndexes()) {
            if (!index.isCompositeIndex()) continue;
            CompositeIndexType iIndex = (CompositeIndexType)index;
            assert (index.indexesKey(key));
            if (iIndex.getCardinality() != Cardinality.SINGLE) continue;
            assert (iIndex.getElement() == ElementCategory.VERTEX);
            indexes.add(iIndex);
        }
        return indexes;
    }

    public static boolean hasAnyIndex(PropertyKey key) {
        InternalRelationType type = (InternalRelationType)((Object)key);
        return !Iterables.isEmpty(type.getKeyIndexes()) || Iterables.size(type.getRelationIndexes()) > 1;
    }

    private static <T> T getTypeModifier(SchemaSource schema, ModifierType modifierType, T defaultValue) {
        for (SchemaSource.Entry entry : schema.getRelated(TypeDefinitionCategory.TYPE_MODIFIER, Direction.OUT)) {
            Object value = entry.getSchemaType().getDefinition().getValue(modifierType.getCategory());
            if (null == value) continue;
            return (T)value;
        }
        return defaultValue;
    }

    public static ConsistencyModifier getConsistencyModifier(SchemaSource schema) {
        return TypeUtil.getTypeModifier(schema, ModifierType.CONSISTENCY, ConsistencyModifier.DEFAULT);
    }

    public static int getTTL(SchemaSource schema) {
        return TypeUtil.getTypeModifier(schema, ModifierType.TTL, 0);
    }
}

