/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import com.google.common.base.Preconditions;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.EdgeLabelMaker;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.database.serialize.AttributeHandler;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.StandardRelationTypeMaker;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeDefinitionMap;

public class StandardEdgeLabelMaker
extends StandardRelationTypeMaker
implements EdgeLabelMaker {
    private Direction unidirectionality = Direction.BOTH;

    public StandardEdgeLabelMaker(StandardJanusGraphTx tx, String name, IndexSerializer indexSerializer, AttributeHandler attributeHandler) {
        super(tx, name, indexSerializer, attributeHandler);
    }

    @Override
    JanusGraphSchemaCategory getSchemaCategory() {
        return JanusGraphSchemaCategory.EDGELABEL;
    }

    @Override
    public StandardEdgeLabelMaker directed() {
        this.unidirectionality = Direction.BOTH;
        return this;
    }

    @Override
    public StandardEdgeLabelMaker unidirected() {
        return this.unidirected(Direction.OUT);
    }

    public StandardEdgeLabelMaker unidirected(Direction dir) {
        Preconditions.checkNotNull((Object)dir);
        this.unidirectionality = dir;
        return this;
    }

    @Override
    public StandardEdgeLabelMaker multiplicity(Multiplicity multiplicity) {
        super.multiplicity(multiplicity);
        return this;
    }

    @Override
    public StandardEdgeLabelMaker signature(PropertyKey ... types) {
        super.signature(types);
        return this;
    }

    @Override
    public StandardEdgeLabelMaker sortKey(PropertyKey ... types) {
        super.sortKey(types);
        return this;
    }

    @Override
    public StandardEdgeLabelMaker sortOrder(Order order) {
        super.sortOrder(order);
        return this;
    }

    @Override
    public StandardEdgeLabelMaker invisible() {
        super.invisible();
        return this;
    }

    @Override
    public EdgeLabel make() {
        TypeDefinitionMap definition = this.makeDefinition();
        Preconditions.checkArgument((this.unidirectionality == Direction.BOTH || !this.getMultiplicity().isUnique(this.unidirectionality.opposite()) ? 1 : 0) != 0, (Object)"Unidirectional labels cannot have restricted multiplicity at the other end");
        Preconditions.checkArgument((this.unidirectionality == Direction.BOTH || !this.hasSortKey() || !this.getMultiplicity().isUnique(this.unidirectionality) ? 1 : 0) != 0, (Object)"Unidirectional labels with restricted multiplicity cannot have a sort key");
        Preconditions.checkArgument((this.unidirectionality != Direction.IN || definition.getValue(TypeDefinitionCategory.INVISIBLE, Boolean.class) != false ? 1 : 0) != 0);
        definition.setValue(TypeDefinitionCategory.UNIDIRECTIONAL, this.unidirectionality);
        return this.tx.makeEdgeLabel(this.getName(), definition);
    }
}

