/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexQuery;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.tinkerpop.optimize.HasStepFolder;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.MultiQueriable;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;

public class JanusGraphVertexStep<E extends Element>
extends VertexStep<E>
implements HasStepFolder<Vertex, E>,
Profiling,
MultiQueriable<Vertex, E> {
    private boolean initialized = false;
    private boolean useMultiQuery = false;
    private Map<JanusGraphVertex, Iterable<? extends JanusGraphElement>> multiQueryResults = null;
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private final List<HasContainer> hasContainers;
    private int limit;
    private final List<HasStepFolder.OrderEntry> orders = new ArrayList<HasStepFolder.OrderEntry>();

    public JanusGraphVertexStep(VertexStep<E> originalStep) {
        super(originalStep.getTraversal(), originalStep.getReturnClass(), originalStep.getDirection(), originalStep.getEdgeLabels());
        originalStep.getLabels().forEach(arg_0 -> ((JanusGraphVertexStep)this).addLabel(arg_0));
        this.hasContainers = new ArrayList<HasContainer>();
        this.limit = Integer.MAX_VALUE;
    }

    @Override
    public void setUseMultiQuery(boolean useMultiQuery) {
        this.useMultiQuery = useMultiQuery;
    }

    public <Q extends BaseVertexQuery> Q makeQuery(Q query) {
        query.labels(this.getEdgeLabels());
        query.direction(this.getDirection());
        for (HasContainer condition : this.hasContainers) {
            query.has(condition.getKey(), JanusGraphPredicate.Converter.convert(condition.getBiPredicate()), condition.getValue());
        }
        for (HasStepFolder.OrderEntry order : this.orders) {
            query.orderBy(order.key, order.order);
        }
        if (this.limit != Integer.MAX_VALUE) {
            query.limit(this.limit);
        }
        ((BasicVertexCentricQueryBuilder)query).profiler(this.queryProfiler);
        return query;
    }

    private void initialize() {
        assert (!this.initialized);
        this.initialized = true;
        if (this.useMultiQuery) {
            if (!this.starts.hasNext()) {
                throw FastNoSuchElementException.instance();
            }
            JanusGraphMultiVertexQuery<? extends JanusGraphMultiVertexQuery> multiQuery = JanusGraphTraversalUtil.getTx(this.traversal).multiQuery(new JanusGraphVertex[0]);
            ArrayList vertices = new ArrayList();
            this.starts.forEachRemaining(v -> {
                vertices.add(v);
                multiQuery.addVertex((Vertex)v.get());
            });
            this.starts.add(vertices.iterator());
            assert (vertices.size() > 0);
            this.makeQuery(multiQuery);
            this.multiQueryResults = Vertex.class.isAssignableFrom(this.getReturnClass()) ? multiQuery.vertices() : multiQuery.edges();
        }
    }

    protected Traverser.Admin<E> processNextStart() {
        if (!this.initialized) {
            this.initialize();
        }
        return super.processNextStart();
    }

    protected Iterator<E> flatMap(Traverser.Admin<Vertex> traverser) {
        if (this.useMultiQuery) {
            assert (this.multiQueryResults != null);
            return this.multiQueryResults.get(traverser.get()).iterator();
        }
        JanusGraphVertexQuery<? extends JanusGraphVertexQuery> query = this.makeQuery(JanusGraphTraversalUtil.getJanusGraphVertex(traverser).query());
        return Vertex.class.isAssignableFrom(this.getReturnClass()) ? query.vertices().iterator() : query.edges().iterator();
    }

    public void reset() {
        super.reset();
        this.initialized = false;
    }

    public JanusGraphVertexStep<E> clone() {
        JanusGraphVertexStep clone = (JanusGraphVertexStep)super.clone();
        clone.initialized = false;
        return clone;
    }

    @Override
    public void addAll(Iterable<HasContainer> has) {
        HasStepFolder.splitAndP(this.hasContainers, has);
    }

    @Override
    public List<HasContainer> addLocalAll(Iterable<HasContainer> has) {
        throw new UnsupportedOperationException("addLocalAll is not supported for graph vertex step.");
    }

    @Override
    public void orderBy(String key, Order order) {
        this.orders.add(new HasStepFolder.OrderEntry(key, order));
    }

    @Override
    public void localOrderBy(List<HasContainer> hasContainers, String key, Order order) {
        throw new UnsupportedOperationException("localOrderBy is not supported for graph vertex step.");
    }

    @Override
    public void setLimit(int low, int high) {
        Preconditions.checkArgument((low == 0 ? 1 : 0) != 0, (Object)"Offset is not supported for properties step.");
        this.limit = high;
    }

    @Override
    public void setLocalLimit(List<HasContainer> hasContainers, int low, int high) {
        throw new UnsupportedOperationException("setLocalLimit is not supported for graph vertex step.");
    }

    @Override
    public int getLowLimit() {
        throw new UnsupportedOperationException("getLowLimit is not supported for properties step.");
    }

    @Override
    public int getLocalLowLimit(List<HasContainer> hasContainers) {
        throw new UnsupportedOperationException("getLocalLowLimit is not supported for properties step.");
    }

    @Override
    public int getHighLimit() {
        return this.limit;
    }

    @Override
    public int getLocalHighLimit(List<HasContainer> hasContainers) {
        throw new UnsupportedOperationException("getLocalHighLimit is not supported for graph vertex step.");
    }

    public String toString() {
        return this.hasContainers.isEmpty() ? super.toString() : StringFactory.stepString((Step)this, (Object[])new Object[]{this.hasContainers});
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }
}

