/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.condition;

import org.apache.commons.lang.builder.HashCodeBuilder;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.graphdb.internal.InternalElement;
import org.janusgraph.graphdb.query.condition.Literal;
import org.janusgraph.graphdb.types.system.SystemRelationType;

public class VisibilityFilterCondition<E extends JanusGraphElement>
extends Literal<E> {
    private final Visibility visibility;

    public VisibilityFilterCondition(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public boolean evaluate(E element) {
        switch (this.visibility) {
            case NORMAL: {
                return !((InternalElement)element).isInvisible();
            }
            case SYSTEM: {
                return element instanceof JanusGraphRelation && ((JanusGraphRelation)element).getType() instanceof SystemRelationType || element instanceof JanusGraphVertex && element instanceof JanusGraphSchemaElement;
            }
        }
        throw new AssertionError((Object)("Unrecognized visibility: " + (Object)((Object)this.visibility)));
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append((Object)this.visibility).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other != null && this.getClass().isInstance(other);
    }

    @Override
    public String toString() {
        return "visibility:" + this.visibility.toString().toLowerCase();
    }

    public static enum Visibility {
        NORMAL,
        SYSTEM;

    }
}

