/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.condition;

import java.util.ArrayList;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.graphdb.query.condition.Condition;

public abstract class MultiCondition<E extends JanusGraphElement>
extends ArrayList<Condition<E>>
implements Condition<E> {
    MultiCondition() {
        this(5);
    }

    MultiCondition(int capacity) {
        super(capacity);
    }

    MultiCondition(Condition<E> ... conditions) {
        super(conditions.length);
        for (Condition<E> condition : conditions) {
            assert (condition != null);
            super.add(condition);
        }
    }

    MultiCondition(MultiCondition<E> cond) {
        this(cond.size());
        super.addAll(cond);
    }

    @Override
    public boolean add(Condition<E> condition) {
        assert (condition != null);
        return super.add(condition);
    }

    @Override
    public boolean hasChildren() {
        return !super.isEmpty();
    }

    @Override
    public int numChildren() {
        return super.size();
    }

    @Override
    public Iterable<Condition<E>> getChildren() {
        return this;
    }

    @Override
    public int hashCode() {
        int sum = 0;
        for (Condition kp : this) {
            sum += kp.hashCode();
        }
        return new HashCodeBuilder().append((Object)this.getType()).append(sum).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        MultiCondition oth = (MultiCondition)other;
        if (this.getType() != oth.getType() || this.size() != oth.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            boolean foundEqual = false;
            for (int j = 0; j < oth.size(); ++j) {
                if (!((Condition)this.get(i)).equals(oth.get((i + j) % oth.size()))) continue;
                foundEqual = true;
                break;
            }
            if (foundEqual) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.toString(this.getType().toString());
    }

    public String toString(String token) {
        StringBuilder b = new StringBuilder();
        b.append("(");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                b.append(" ").append(token).append(" ");
            }
            b.append(this.get(i));
        }
        b.append(")");
        return b.toString();
    }
}

