/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Contain;
import org.janusgraph.graphdb.predicate.AndJanusPredicate;
import org.janusgraph.graphdb.predicate.ConnectiveJanusGraphP;
import org.janusgraph.graphdb.predicate.ConnectiveJanusPredicate;
import org.janusgraph.graphdb.predicate.OrJanusPredicate;

public interface JanusGraphPredicate
extends BiPredicate<Object, Object> {
    public boolean isValidCondition(Object var1);

    public boolean isValidValueType(Class<?> var1);

    public boolean hasNegation();

    public JanusGraphPredicate negate();

    public boolean isQNF();

    @Override
    public boolean test(Object var1, Object var2);

    public static class Converter {
        public static JanusGraphPredicate convertInternal(BiPredicate p) {
            if (p instanceof JanusGraphPredicate) {
                return (JanusGraphPredicate)p;
            }
            if (p instanceof Compare) {
                Compare comp = (Compare)p;
                switch (comp) {
                    case eq: {
                        return Cmp.EQUAL;
                    }
                    case neq: {
                        return Cmp.NOT_EQUAL;
                    }
                    case gt: {
                        return Cmp.GREATER_THAN;
                    }
                    case gte: {
                        return Cmp.GREATER_THAN_EQUAL;
                    }
                    case lt: {
                        return Cmp.LESS_THAN;
                    }
                    case lte: {
                        return Cmp.LESS_THAN_EQUAL;
                    }
                }
                throw new IllegalArgumentException("Unexpected comparator: " + comp);
            }
            if (p instanceof Contains) {
                Contains con = (Contains)p;
                switch (con) {
                    case within: {
                        return Contain.IN;
                    }
                    case without: {
                        return Contain.NOT_IN;
                    }
                }
                throw new IllegalArgumentException("Unexpected container: " + con);
            }
            return null;
        }

        public static JanusGraphPredicate convert(BiPredicate p) {
            JanusGraphPredicate janusgraphPredicate = Converter.convertInternal(p);
            if (janusgraphPredicate == null) {
                throw new IllegalArgumentException("JanusGraph does not support the given predicate: " + p);
            }
            return janusgraphPredicate;
        }

        public static boolean supports(BiPredicate p) {
            return Converter.convertInternal(p) != null;
        }

        public static HasContainer convert(HasContainer container) {
            if (!(container.getPredicate() instanceof ConnectiveP)) {
                return container;
            }
            ConnectiveJanusPredicate connectivePredicate = Converter.instanceConnectiveJanusPredicate(container.getPredicate());
            return new HasContainer(container.getKey(), (P)new ConnectiveJanusGraphP(connectivePredicate, Converter.convert((ConnectiveP)container.getPredicate(), connectivePredicate)));
        }

        public static ConnectiveJanusPredicate instanceConnectiveJanusPredicate(P<?> predicate) {
            ConnectiveJanusPredicate connectivePredicate;
            if (predicate.getClass().isAssignableFrom(AndP.class)) {
                connectivePredicate = new AndJanusPredicate();
            } else if (predicate.getClass().isAssignableFrom(OrP.class)) {
                connectivePredicate = new OrJanusPredicate();
            } else {
                throw new IllegalArgumentException("JanusGraph does not support the given predicate: " + predicate);
            }
            return connectivePredicate;
        }

        public static List<Object> convert(ConnectiveP<?> predicate, ConnectiveJanusPredicate connectivePredicate) {
            ArrayList<Object> toReturn = new ArrayList<Object>();
            for (P p : predicate.getPredicates()) {
                if (p instanceof ConnectiveP) {
                    ConnectiveJanusPredicate subPredicate = Converter.instanceConnectiveJanusPredicate(p);
                    toReturn.add(Converter.convert((ConnectiveP)p, subPredicate));
                    connectivePredicate.add(subPredicate);
                    continue;
                }
                connectivePredicate.add(Converter.convert(p.getBiPredicate()));
                toReturn.add(p.getValue());
            }
            return toReturn;
        }
    }
}

