/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize;

import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.attribute.Geoshape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeUtil {
    private static final Logger log = LoggerFactory.getLogger(AttributeUtil.class);

    public static boolean isWholeNumber(Number n) {
        return AttributeUtil.isWholeNumber(n.getClass());
    }

    public static boolean isDecimal(Number n) {
        return AttributeUtil.isDecimal(n.getClass());
    }

    public static boolean isWholeNumber(Class<?> clazz) {
        return clazz.equals(Long.class) || clazz.equals(Integer.class) || clazz.equals(Short.class) || clazz.equals(Byte.class);
    }

    public static boolean isDecimal(Class<?> clazz) {
        return clazz.equals(Double.class) || clazz.equals(Float.class);
    }

    public static boolean isString(Object o) {
        return AttributeUtil.isString(o.getClass());
    }

    public static boolean isString(Class<?> clazz) {
        return clazz.equals(String.class);
    }

    public static boolean isGeo(Class<?> clazz) {
        return clazz.equals(Geoshape.class);
    }

    public static Integer compare(Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return null;
        }
        assert (a != null && b != null);
        if (a instanceof Number && b instanceof Number) {
            Number an = (Number)a;
            Number bn = (Number)b;
            if (Double.isNaN(an.doubleValue()) || Double.isNaN(bn.doubleValue())) {
                if (Double.isNaN(an.doubleValue()) && Double.isNaN(bn.doubleValue())) {
                    return 0;
                }
                return null;
            }
            if (an.doubleValue() == bn.doubleValue()) {
                return Long.compare(an.longValue(), bn.longValue());
            }
            return Double.compare(an.doubleValue(), bn.doubleValue());
        }
        try {
            return ((Comparable)a).compareTo(b);
        }
        catch (Throwable e) {
            log.debug("Could not compare elements: {} - {}", a, b);
            return null;
        }
    }

    public static boolean hasGenericDataType(PropertyKey key) {
        return key.dataType().equals(Object.class);
    }
}

