/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import org.janusgraph.diskstorage.util.UELogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncaughtExceptionLogger
implements Thread.UncaughtExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(Thread.UncaughtExceptionHandler.class);
    private final UELevel level;

    public UncaughtExceptionLogger(UELevel level) {
        this.level = level;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.level.dispatch(String.format("Uncaught exception in thread " + t, new Object[0]), e);
    }

    public static enum UELevel implements UELogLevel
    {
        TRACE{

            @Override
            public void dispatch(String message, Throwable t) {
                log.trace(message, t);
            }
        }
        ,
        DEBUG{

            @Override
            public void dispatch(String message, Throwable t) {
                log.debug(message, t);
            }
        }
        ,
        INFO{

            @Override
            public void dispatch(String message, Throwable t) {
                log.info(message, t);
            }
        }
        ,
        WARN{

            @Override
            public void dispatch(String message, Throwable t) {
                log.warn(message, t);
            }
        }
        ,
        ERROR{

            @Override
            public void dispatch(String message, Throwable t) {
                log.error(message, t);
            }
        };

    }
}

